% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d17O.R
\name{mix_d17O}
\alias{mix_d17O}
\title{Mixing curves in triple oxygen isotope space}
\usage{
mix_d17O(d18O_A, d17O_A, d18O_B, d17O_B, lambda = 0.528)
}
\arguments{
\item{d18O_A}{d18O value of component A (‰).}

\item{d17O_A}{d17O value of component A (‰).}

\item{d18O_B}{d18O value of component B (‰).}

\item{d17O_B}{d17O value of component B (‰).}

\item{lambda}{Triple oxygen isotope reference slope. Default \code{0.528}.}
}
\value{
Returns a data frame:
\enumerate{
\item d18O value of the mixture at x\% mixing (‰).
\item d18O value of the mixture x\% mixing (‰).
\item relative amount of component B in the mixture (\%):
from 100\% A and 0\% B to 0\% A and 100\% B.
}
}
\description{
\code{mix_d17O()} produces mixing curves between two endmembers (A and B) in
triple oxygen isotope space (d18O vs. D17O).
}
\examples{
mix_d17O(d18O_A = d17O_c(10, -1)[1], d17O_A = d17O_c(10, -1)[2],
         d18O_B = d17O_c(100,0)[1], d17O_B = d17O_c(100, 0)[2])

}
\seealso{
\code{\link[=d17O_c]{d17O_c()}} calculates equilibrium calcite d18O, d17O, and D17O
values for a given temperature.
}
