% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_functions.R
\name{orbi_read_isox}
\alias{orbi_read_isox}
\title{Read IsoX file}
\usage{
orbi_read_isox(file)
}
\arguments{
\item{file}{Path to the \code{.isox} file}
}
\value{
A tibble containing at minimum the columns \code{filename}, \code{scan.no}, \code{time.min}, \code{compound}, \code{isotopocule}, \code{ions.incremental}, \code{tic}, \code{it.ms}
}
\description{
Read an IsoX output file (\code{.isox}) into a tibble data frame
}
\details{
Additional information on the columns:
\itemize{
\item \code{filename}: name of the original Thermo \code{.raw} file processed by IsoX
\item \code{scan.no}: scan number
\item \code{time.min}: acquisition or retention time in minutes
\item \code{compound}: name of the compound (e.g., NO3-)
\item \code{isotopocule}: name of the isotopocule (e.g., 15N); called \code{isotopolog} in \code{.isox}
\item \code{ions.incremental}: estimated number of ions, in increments since it is a calculated number
\item \code{tic}: total ion current (TIC) of the scan
\item \code{it.ms}: scan injection time (IT) in milli seconds (ms)
}
}
\examples{
fpath <- system.file("extdata", "testfile_dual_inlet.isox", package="isoorbi")
df <- orbi_read_isox(file = fpath)

}
