% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanup.R
\name{extract_data}
\alias{extract_data}
\title{Overview of text data extraction functions}
\description{
The following functions are intended to make it easy to extract relevant information from textual data.
These functions are primarily intended for use in \code{\link{iso_mutate_file_info}} and inside the filtering conditions passed to \code{\link{iso_filter_files}}. However, they can of course also be used stand-alone and in regular \code{\link[dplyr]{mutate}} or \code{\link[dplyr]{filter}} calls on the data frames returned by the data retrieval functions (\code{\link{iso_get_raw_data}}, \code{\link{iso_get_file_info}}, \code{\link{iso_get_vendor_data_table}}, etc.). Not that all the \code{parse_} functions are used in \code{\link{iso_parse_file_info}} for easy type conversions.
}
\details{
For simultaneous extraction of pure text data into multiple columns, please see the \code{\link[tidyr]{extract}} function from the \link{tidyr} package.

\itemize{
\item \code{\link{extract_substring}} is a generic convenience function to extract parts of textual data (based on regular expression matches).
Can be used in combination with the parsing functions to turn extracted substrings into numerical or logical data.

\item \code{\link{extract_word}} is a more specific convenience function to extract the 1st/2nd/3rd word from textual data.

\item \code{\link[readr:parse_atomic]{parse_number}} is a convenience function to extract a number even if it is surrounded by text (re-exported from the \link{readr} package).

\item \code{\link[readr:parse_atomic]{parse_double}} parses text that holds double (decimal) numerical values without any extraneous text around -
use \code{\link[readr:parse_atomic]{parse_number}} instead if this is not the case (re-exported from the \link{readr} package)

\item \code{\link[readr:parse_atomic]{parse_integer}} parses text that holds integer (whole number) numerical values without any extraneous text around -
use \code{\link[readr:parse_atomic]{parse_number}} instead if this is not the case (re-exported from the \link{readr} package)

\item \code{\link[readr:parse_atomic]{parse_logical}} parses text that holds logical (boolean, i.e. TRUE/FALSE) values (re-exported from the \link{readr} package)

\item \code{\link[readr:parse_atomic]{parse_datetime}} parses text that holds date and time information (re-exported from the \link{readr} package)

}
}
\seealso{
Other data extraction functions: 
\code{\link{extract_substring}()},
\code{\link{extract_word}()}
}
\concept{data extraction functions}
