% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-li2017.R
\docType{data}
\name{li2017}
\alias{li2017}
\alias{li2017_prots}
\alias{li2017_counts}
\title{Protein degradation in Arabidopsis plants (Li et al. 2017)}
\format{
\code{li2017} is the main dataset and is a tibble with columns:
\describe{
  \item{prot_id}{Protein identifier. Can be matched to a more explicit
    protein description in \code{li2017_prots}.}
  \item{sample}{Sample identity. Different samples were used for relative
    abundance measurements and labelled fraction measurements.}
  \item{rel_abundance}{Relative abundance compared to a reference sample.}
  \item{labeled_fraction}{Proportion of 15N in the protein.}
  \item{time_day}{Time elapsed since growth medium switch to 15N, in days.}
  \item{leaf_id}{Leaf identity (3rd, 5th, or 7th leaf of individual plants).}
}

\code{li2017_prots} maps protein identifiers to protein descriptions
    and is a tibble with columns:
\describe{
  \item{prot_id}{Protein identifier. Can be matched with the same column in
    \code{li2017}.}
  \item{description}{Protein description}
}

\code{li2017_counts} is a summary table counting the number of
    available data points for relative abundance and labelled fraction for
    each protein in \code{li2017}. It is a tibble with columns:
\describe{
  \item{prot_id}{Protein identifier. Can be matched with the same column in
    \code{li2017}.}
  \item{n_abundance_data}{Number of relative abundance data points for a
    given protein.}
  \item{n_labelling_data}{Number of labelled fraction data points for a
    given protein.}
}
}
\source{
Data was taken from the following Dryad repository: Li, Lei, Clark
    J. Nelson, Josua Troesch, Ian Castleden, Shaobai Huang, and A. Harvey
    Millar. “Data from: Protein Degradation Rate in Arabidopsis Thaliana
    Leaf Growth and Development.” Dryad,
    2018. https://doi.org/10.5061/DRYAD.Q3H85.

The Dryad repository was associated with the following paper: Li,
    Lei, Clark J. Nelson, Josua Trösch, Ian Castleden, Shaobai Huang, and
    A. Harvey Millar. “Protein Degradation Rate in Arabidopsis Thaliana Leaf
    Growth and Development.” The Plant Cell 29, no. 2 (February 1, 2017):
    207–28. https://doi.org/10.1105/tpc.16.00768.
}
\usage{
li2017
}
\description{
Dataset built from the Dryad depository entry associated with the article
"Protein degradation rate in Arabidopsis thaliana leaf growth and development"
by Li et al. (2017)
}
\details{
In this study, the authors used a growth medium containing 15N to grow
21-day old Arabidopsis plants which were grown on a natural 14N/15N medium
until that day. The third, fifth and seventh leaves were sampled from
individuals at different time points after the medium switch (0, 1, 3 and 5
days). Proteins were identified and labelled fractions were measured using
mass spectrometry. Relative protein abundances were determined in comparison
with a reference sample.

The aim of the authors was to quantify in vivo degradation rates for as many
proteins as possible (1228 proteins in the original paper) and examine which
determinants had an effect or not on protein degradation rates (e.g. protein
domains, protein complex membership, ...).

Three datasets were extracted from the large dataset available on Dryad for
packaging inside isotracer: \code{li2017}, \code{li2017_prots}, and
\code{li2017_counts}.
}
\keyword{datasets}
