% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{set_prior}
\alias{set_prior}
\alias{set_priors}
\title{Set prior(s) for a network model}
\usage{
set_prior(x, prior, param = "", use_regexp = TRUE, quiet = FALSE)

set_priors(x, prior, param = "", use_regexp = TRUE, quiet = FALSE)
}
\arguments{
\item{x}{A \code{networkModel} object.}

\item{prior}{A prior built with e.g. uniform_p() or hcauchy_p(). Call
\code{available_priors()} to see a table of implemented
priors. Alternatively, if \code{prior} is a tibble, the function will
try to use it to set parameter priors. The format of such an argument is
the same as the format of the output of the getter function
\code{priors()} (see examples). Note that if `prior` is given as a
tibble, all other arguments (except `x`) are disregarded.}

\item{param}{String, target parameter or regexp to target several
parameters. Default is the empty string \code{""}, which will match all
parameters.}

\item{use_regexp}{Boolean, if \code{TRUE} (the default) then \code{param} is
used as a regular expression to match one or several parameter names.}

\item{quiet}{Boolean, if \code{FALSE} print a message indicating which
parameters had their prior modified.}
}
\value{
A \code{networkModel} object.
}
\description{
Set prior(s) for a network model
}
\examples{
# Copy `aquarium_mod`
m <- aquarium_mod
priors(m)

# Modify the priors of `m`
m <- set_priors(m, exponential_p(0.5), "lambda")
priors(m)

# Re-apply priors from the original `aquarium_mod`
prev_priors <- priors(aquarium_mod)
prev_priors
m <- set_priors(m, prev_priors)
priors(m)

}
