% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_plotting-topology.R
\name{ggflows}
\alias{ggflows}
\title{A quick-and-dirty way of visualizing relative flows in a network}
\usage{
ggflows(x, layout = "auto", edge = "fan", max_width, legend = TRUE, ...)
}
\arguments{
\item{x}{A tibble with the flow estimates, with columns "from", "to", and
"flow".}

\item{layout}{Optional, layout to use (e.g. "sugiyama", "kk", "stress")}

\item{edge}{"curve" (the default), "line" or "fan".}

\item{max_width}{Optional, numeric giving the maximum edge width (minimum
width is always 1).}

\item{legend}{Boolean, display edge width legend?}

\item{...}{Not used.}
}
\value{
A ggplot2 plot.
}
\description{
A quick-and-dirty way of visualizing relative flows in a network
}
\examples{
if (requireNamespace("ggraph")) {
  z <- tibble::tribble(
               ~from,               ~to,            ~flow,
     "leavesAndStem", "rootsAndRhizome", 333.929866077124,
        "lowerWater", "rootsAndRhizome", 4425.15780019304,
   "rootsAndRhizome",   "leavesAndStem", 525.208837577916,
        "upperWater",   "leavesAndStem", 11224.0814971855
  )
  ggflows(z)
  ggflows(z, max_width = 15)
}

}
