% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_getters.R
\name{missing_priors}
\alias{missing_priors}
\title{Get a table with parameters which are missing priors}
\usage{
missing_priors(nm)
}
\arguments{
\item{nm}{A \code{networkModel} object.}
}
\value{
A tibble containing the parameters which are missing a prior. If no
    priors are missing, the tibble contains zero row.
}
\description{
Get a table with parameters which are missing priors
}
\examples{
# Using a subset of the topology from the Trinidad case study
m <- new_networkModel() \%>\%
  set_topo("NH4, NO3 -> epi, FBOM", "epi -> petro, pseph")

# No prior is set by default
priors(m)

# Set some priors
m <- set_priors(m, normal_p(0, 10), "lambda")
priors(m)

# Which parameters are missing a prior?
missing_priors(m)

}
