% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itan.R
\name{calcularIndiceDiscriminacion}
\alias{calcularIndiceDiscriminacion}
\title{Índice de discriminación}
\usage{
calcularIndiceDiscriminacion(
  respuestasCorregidas,
  tipo = "dc1",
  proporcion = 0.27,
  digitos = 2
)
}
\arguments{
\item{respuestasCorregidas}{Un data frame con los puntajes obtenidos por los
estudiantes en cada pregunta.}

\item{tipo}{Una cadena de texto que indica el tipo de índice de discriminación
a calcular. Valores posibles son: "dc1" o "dc2"}

\item{proporcion}{Proporción de estudiantes que forman parte de los grupos superior
e inferior. Valores habituales son 0.25, 0.27 y 0.33.}

\item{digitos}{La cantidad de dígitos significativos que tendrá el resultado.}
}
\value{
Un vector con el índice de discriminación para cada ítem.
}
\description{
Calcula el índice de discriminación para cada ítem.
}
\details{
Los índices de discriminación permiten determinar
si un ítem diferencia entre estudiantes con alta o baja habilidad.
Se calculan a partir del grupo de estudiantes con mejor y peor puntuación
en el test.

El índice de discriminación 1 (dc1) corresponde a la diferencia entre
la proporción de aciertos del grupo superior y la proporción
de aciertos del grupo inferior. Los valores extremos que puede alcanzar este
índice son 0 y +/-1. Los ítems con discriminación negativa favorecen a los
estudiantes con baja puntuación en el test y en principio deben ser revisados.
Este índice se ve influenciado por el índice de dificultad, por lo que a veces
es conveniente compararlo con el índice de discriminación 2 (dc2).

El índice de discriminación 2 (dc2) corresponde a la proporción de aciertos del
grupo superior en relación al total de aciertos de ambos grupos. Los valores de
este índice van de 0 a 1. Pueden considerarse satisfactorios valores mayores a 0.5.
Este índice es independiente del nivel de dificultad de la pregunta.
}
\examples{
respuestas <- datos[,-1]
respuestasCorregidas <- corregirRespuestas(respuestas, clave)
dc1 <- calcularIndiceDiscriminacion(respuestasCorregidas, tipo="dc1", proporcion=0.25)
dc2 <- calcularIndiceDiscriminacion(respuestasCorregidas, tipo="dc2", proporcion=0.25)
p <- calcularIndiceDificultad(respuestasCorregidas, proporcion=0.25)
cbind(p, dc1, dc2)

}
\references{
Morales, P. (2009). Análisis de ítem en las pruebas objetivas.
Madrid. Recuperado de \url{https://educrea.cl/wp-content/uploads/2014/11/19-nov-analisis-de-items-en-las-pruebas-objetivas.pdf}
}
\seealso{
\code{\link{corregirRespuestas}}, \code{\link{calcularIndiceDificultad}}, \code{\link{datos}} y \code{\link{clave}}.
}
