% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itrax_image.r
\name{itrax_image}
\alias{itrax_image}
\title{Read an Itrax Image File}
\usage{
itrax_image(
  file = "optical.tif",
  meta = "document.txt",
  plot = FALSE,
  trim = TRUE
)
}
\arguments{
\item{file}{defines the name of the datafile to parse}

\item{meta}{defines the relating metadata}

\item{plot}{would you like to create a plot as a side-effect?}

\item{trim}{defines custom trim parameters. The default behaviour uses the limits from the metadata file. Set the false for no trimming, or set the position limits by passing a two element vector.}
}
\value{
a matrix of RGB values, and the relevant data from the metadata file relating to the image.
}
\description{
Reads an Itrax image file and trims it according to the metadata provided.
}
\examples{
itrax_image(file = system.file("extdata",
                         "CD166_19_S1_optical_lowres.tif",
                         package = "itraxR",
                         mustWork = TRUE),
            meta = system.file("extdata",
                         "CD166_19_S1_xrf_document.txt",
                         package = "itraxR",
                         mustWork = TRUE),
            plot = TRUE)

}
