% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/predictions.R
\name{get_random}
\alias{get_random}
\title{Get model predictions for the random effects.}
\usage{
get_random(model, fun = NULL, cond = NULL, n.grid = 30,
  print.summary = TRUE)
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{fun}{A string or function description to apply to the random effects
estimates. When NULL (default), the estimates for the random effects are
returned.}

\item{cond}{A named list of the values to restrict the estimates for the
random predictor terms. When NULL (default) all levels are returned.}

\item{n.grid}{Number of data points estimated for each random smooth.}

\item{print.summary}{Logical: whether or not to print a summary of the
values selected for each predictor. Defaults to TRUE.}
}
\value{
A data frame with estimates for random effects.
}
\description{
Get model predictions for the random effects.
}
\examples{
# see the vignette for examples:
vignette("plotfunctions", package="itsadug")
}
\author{
Jacolien van Rij
}
\seealso{
Other functions for model predictions: \code{\link{get_difference}};
  \code{\link{get_modelterm}};
  \code{\link{get_predictions}}
}

