% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.IndependentResponse}
\alias{plot.IndependentResponse}
\title{Function to plot independent response curves.}
\usage{
\method{plot}{IndependentResponse}(x, target_var = NA, smooth_span = 0.3, ...)
}
\arguments{
\item{x}{(\code{IndependentResponse}) The independent response curve object to plot.
It could be the return of function \code{\link{independent_response}}.}

\item{target_var}{(\code{vector} of \code{character}) The target variable to plot. It could be
\code{NA}. If it is \code{NA}, all variables will be plotted.}

\item{smooth_span}{(\code{numeric}) The span value for smooth fit in \code{ggplot2}.
When it is \code{0}, no smooth applied. The default is \code{0.3}.}

\item{...}{Not used.}
}
\value{
\code{ggplot2} figure of response curves
}
\description{
Plot independent response curves using ggplot2.
}
\examples{
\donttest{
# Using a pseudo presence-only occurrence dataset of
# virtual species provided in this package
library(dplyr)
library(sf)
library(stars)
library(itsdm)

data("occ_virtual_species")
occ_virtual_species <- occ_virtual_species \%>\%
  mutate(id = row_number())

set.seed(11)
occ <- occ_virtual_species \%>\% sample_frac(0.7)
occ_test <- occ_virtual_species \%>\% filter(! id \%in\% occ$id)
occ <- occ \%>\% select(-id)
occ_test <- occ_test \%>\% select(-id)

env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars() \%>\%
  slice('band', c(1, 5, 12, 16))

mod <- isotree_po(
  occ = occ, occ_test = occ_test,
  variables = env_vars, ntrees = 50,
  sample_size = 0.8, ndim = 2L,
  seed = 123L, response = FALSE,
  spatial_response = FALSE,
  check_variable = FALSE)

independent_responses <- independent_response(
  model = mod$model,
  var_occ = mod$var_train \%>\% st_drop_geometry(),
  variables = mod$variables)
plot(independent_responses)
}

}
\seealso{
\code{\link{independent_response}}
}
