% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivdesc.R
\name{ivdesc}
\alias{ivdesc}
\title{Profiling compliers and non-compliers for instrumental variable analysis}
\usage{
ivdesc(X, D, Z, variance = FALSE, boot = TRUE, bootn = 1000,
  balance = TRUE, ...)
}
\arguments{
\item{X}{vector with numeric covariate}

\item{D}{vector with binary treatment}

\item{Z}{vector with binary instrument}

\item{variance}{Calculate the variance of the covariate for each subgroup?}

\item{boot}{Replace all standard errors with bootstrap standard errors?}

\item{bootn}{number of bootstraps (ignored if \code{boot=FALSE} )}

\item{balance}{Run balance test?}

\item{...}{additional arguments to be passed to \code{ivdesc_all}}
}
\value{
Returns a object \code{ivdesc} with estimates for each subgroup (\code{co}: complier, \code{nt}: never-taker, \code{at} : always-taker) and the full sample: 

\itemize{
	\item \code{mu} and \code{mu_se} : Mean of \code{X} and standard error
 \item \code{pi} and \code{pi_se}: Proportion of each subgroup in the sample and standard error 
 \item \code{var}: Variance of \code{X} (if \code{variance=TRUE})
}

Can be coerced to a proper \code{data.frame} using \code{as.data.frame}.
}
\description{
Estimates the mean and variance of a covariate for the complier, never-taker and always-taker subpopulation.
}
\details{
This function estimates the mean and the associated standard error of \code{X} for the complier, never-taker and always-taker subpopulation within a sample where some, but not all, units are encouraged by instrument \code{Z} to take the treatment \code{D}. 
Observations with missing values in either \code{X}, \code{D}, or \code{Z} are droppped (listwise deletion). 

One-sided noncompliance is supported. The mean for the always-/never-taker subpopulation will only be computed if there are at least two observed units in these subpopulations.

If \code{boot=FALSE}, analytical standard errors are calculated for the mean of the whole sample as well as the never-taker and always-taker subpopulation. For the complier subpopulation no analytical estimator for the standard error is available. 

The balance test is a t-test allowing for unequal variances.
}
\examples{
 

 # Example 1: Albertson/Lawrence (2009)
 # see Marbach/Hangartner (2019) for details/discussion

 library(icsw)
 data(FoxDebate)

 with(FoxDebate, ivdesc(X=readnews,D=watchpro,Z=conditn) )  

 

 \donttest{

 # Example 2: JTPA Data

 library(haven)
 jtpa <- read_dta("http://fmwww.bc.edu/repec/bocode/j/jtpa.dta") 

 with(jtpa, ivdesc(age, training, assignmt, bootn=500))
 with(jtpa, ivdesc(hispanic, training, assignmt, boot=FALSE))

 }
 
 


}
\references{
Moritz Marbach and Dominik Hangartner. (2019). Profiling Compliers and Non-compliers for Instrumental Variable Analysis. \emph{Political Analysis} (forthcoming).
}
\seealso{
\code{\link[AER]{ivreg}}
}
