% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mst.R
\name{ivmte}
\alias{ivmte}
\title{Instrumental Variables: Extrapolation by Marginal Treatment Effects}
\usage{
ivmte(bootstraps = 0, bootstraps.m, bootstraps.replace = TRUE,
  levels = c(0.99, 0.95, 0.9), ci.type = "both", pvalue.tol = 1e-08,
  ivlike, data, subset, components, propensity, link = "logit", treat,
  m0, m1, uname = u, target, target.weight0 = NULL, target.weight1,
  target.knots0, target.knots1 = NULL, late.Z, late.from, late.to,
  late.X, eval.X, genlate.lb, genlate.ub, obseq.tol = 0.05,
  grid.nu = 20, grid.nx = 20, audit.nx = 20, audit.nu = 20,
  audit.max = 10, audit.tol = 1e-08, m1.ub, m0.ub, m1.lb, m0.lb,
  mte.ub, mte.lb, m0.dec, m0.inc, m1.dec, m1.inc, mte.dec, mte.inc,
  lpsolver = NULL, point = FALSE, noisy = TRUE, seed = 12345)
}
\arguments{
\item{bootstraps}{integer, default set to 0.}

\item{bootstraps.m}{integer, default set to size of data
set. Determines the size of the subsample drawn from the
original data set when performing inference via the
bootstrap. This option applies only to the case of constructing
confidence intervals for treatment effect bounds, i.e. it does
not apply when \code{point = TRUE}.}

\item{bootstraps.replace}{boolean, default set to \code{TRUE}. This
determines whether the resampling procedure used for inference
will sample with replacement.}

\item{levels}{vector, real numbers between 0 and 1. Values
correspond to the level of the confidence intervals constructed
via bootstrap.}

\item{ci.type}{character, default set to 'both'. Set to 'forward'
to construct the forward confidence interval for the treatment
effect bound. Set to 'backward' to construct the backward
confidence interval for the treatment effect bound. Set to
'both' to construct both types of confidence intervals.}

\item{pvalue.tol}{numeric, default set to 1e-08. Tolerance level
for determining p-value of treatment effect bound.}

\item{ivlike}{formula or vector of formulas used to specify the
regressions for the IV-like estimands.}

\item{data}{\code{data.frame} used to estimate the treatment
effects.}

\item{subset}{single subset condition or list of subset conditions
corresponding to each IV-like estimand. The input must be
logical. See \code{\link{l}} on how to input the argument. If
the user wishes to select specific rows, construct a binary
variable in the data set, and set the condition to use only
those observations for which the binary variable is 1, e.g. the
binary variable is \code{use}, and the subset condition is
\code{use == 1}.}

\item{components}{a list of vectors of the terms/components from
the regressions specifications we want to include in the set of
IV-like estimands. To select the intercept term, include in the
vector of variable names, `intercept'. If the the factorized
counterpart of a variable \code{x = 1, 2, 3} is included in the
IV-like specifications via \code{factor(x)}, the user can
select the coefficients for specific factors by declaring the
components \code{factor(x)-1, factor(x)-2, factor(x)-3}. See
\code{\link{l}} on how to input the argument. If no components
for a IV specification are given, then all components from that
IV specification will be included.}

\item{propensity}{formula or variable name corresponding to
propensity to take up treatment. If a formula is declared, then
the function estimates propensity score according to the
formula and link specified. If a variable name is declared,
then the corresponding column in the data is taken as the
vector of propensity scores.}

\item{link}{name of link function to estimate propensity score. Can
be chosen from \code{linear}, \code{probit}, or
\code{logit}. Default is set to "logit".}

\item{treat}{variable name for treatment indicator}

\item{m0}{one-sided formula for marginal treatment response
function for control group. Splines can also be incorporated
using the expression "uSplines(degree, knots, intercept)". The
'intercept' argument may be omitted, and is set to \code{TRUE}
by default.}

\item{m1}{one-sided formula for marginal treatment response
function for treated group. Splines can also be incorporated
using the expression "uSplines(degree, knots, intercept)". The
'intercept' argument may be omitted, and is set to \code{TRUE}
by default.}

\item{uname}{variable name for unobservable used in declaring MTRs.}

\item{target}{target parameter to be estimated. Currently function
allows for ATE ("\code{ate}"), ATT ("\code{att}"), ATU
("\code{atu}"), LATE ("\code{late}"), and generalized LATE
("\code{genlate}").}

\item{target.weight0}{user-defined weight function for the control
group defining the target parameter. A list of functions can be
submitted if the weighting function is in fact a spline. The
arguments of the function should be variable names in
\code{data}. If the weight is constant across all observations,
then the user can instead submit the value of the weight
instead of a function.}

\item{target.weight1}{user-defined weight function for the treated
group defining the target parameter. A list of functions can be
submitted if the weighting function is in fact a spline. The
arguments of the function should be variable names in
\code{data}. If the weight is constant across all observations,
then the user can instead submit the value of the weight
instead of a function.}

\item{target.knots0}{user-defined set of functions defining the
knots associated with splines weights for the control
group. The arguments of the function should consist only of
variable names in \code{data}. If the knots are constant across
all observations, then the user can instead submit the vector
of knots instead of a function.}

\item{target.knots1}{user-defined set of functions defining the
knots associated with splines weights for the treated
group. The arguments of the function should be variable names
in \code{data}. If the knots are constant across all
observations, then the user can instead submit the vector of
knots instead of a function.}

\item{late.Z}{vector of variable names used to define the LATE.}

\item{late.from}{baseline set of values of Z used to define the
LATE.}

\item{late.to}{comparison set of values of Z used to define the
LATE.}

\item{late.X}{vector of variable names of covariates which we
condition on when defining the LATE.}

\item{eval.X}{numeric vector of the values at which we condition
variables in \code{late.X} on when estimating the LATE.}

\item{genlate.lb}{lower bound value of unobservable u for
estimating generalized LATE.}

\item{genlate.ub}{upper bound value of unobservable u for
estimating generalized LATE.}

\item{obseq.tol}{threshold for violation of observational
equivalence. The threshold enters in multiplicatively. Thus, a
value of 0 corresponds to no violation of observational
equivalence other than statistical noise, and the assumption
that the model is correctly specified.}

\item{grid.nu}{number of evenly spread points in the interval [0,
1] of the unobservable u used to form the grid for imposing
shape restrictions on the MTRs.}

\item{grid.nx}{number of evenly spread points of the covariates to
use to form the grid for imposing shape restrictions on the
MTRs.}

\item{audit.nx}{number of points on the covariates space to audit
in each iteration of the audit procedure.}

\item{audit.nu}{number of points in the interval [0, 1],
corresponding to the normalized value of the unobservable term,
to audit in each iteration of the audit procedure.}

\item{audit.max}{maximum number of iterations in the audit
procedure.}

\item{audit.tol}{tolerance for determining when to end the audit
procedure.}

\item{m1.ub}{numeric value for upper bound on MTR for treated
group. By default, this will be set to the largest value of the
observed outcome in the estimation sample.}

\item{m0.ub}{numeric value for upper bound on MTR for control
group. By default, this will be set to the largest value of the
observed outcome in the estimation sample.}

\item{m1.lb}{numeric value for lower bound on MTR for treated
group. By default, this will be set to the smallest value of
the observed outcome in the estimation sample.}

\item{m0.lb}{numeric value for lower bound on MTR for control
group. By default, this will be set to the smallest value of
the observed outcome in the estimation sample.}

\item{mte.ub}{numeric value for upper bound on treatment effect
paramter of interest.}

\item{mte.lb}{numeric value for lower bound on treatment effect
paramter of interest.}

\item{m0.dec}{logical, equal to TRUE if we want MTR for control
group to be weakly monotone decreasing.}

\item{m0.inc}{logical, equal to TRUE if we want MTR for control
group to be weakly monotone increasing.}

\item{m1.dec}{logical, equal to TRUE if we want MTR for treated
group to be weakly monotone decreasing.}

\item{m1.inc}{logical, equal to TRUE if we want MTR for treated
group to be weakly monotone increasing.}

\item{mte.dec}{logical, equal to TRUE if we want the MTE to be
weakly monotone decreasing.}

\item{mte.inc}{logical, equal to TRUE if we want the MTE to be
weakly monotone decreasing.}

\item{lpsolver}{name of the linear programming package in R used to
obtain the bounds on the treatment effect.}

\item{point}{boolean, default set to \code{FALSE}. Set to
\code{TRUE} if it is believed that the treatment effects are
point identified. If set to \code{TRUE}, then a two-step GMM
procedure is implemented to estimate the treatment
effects. Shape constraints on the MTRs will be ignored under
point identification.}

\item{noisy}{boolean, default set to \code{TRUE}. If \code{TRUE},
then messages are provided throughout the estimation
procedure. Set to \code{FALSE} to suppress all messages,
e.g. when performing the bootstrap.}

\item{seed}{integer, the seed that determines the random grid in
the audit procedure.}
}
\value{
Returns a list of results from throughout the estimation
    procedure. This includes all IV-like estimands; the propensity
    score model; bounds on the treatment effect; the estimated
    expectations of each term in the MTRs; the components and
    results of the LP problem.
}
\description{
This function provides a general framework for using the marginal treatment
effect (MTE) to extrapolate. The model is the same binary treatment
instrumental variable (IV) model considered by
\href{https://doi.org/10.2307/2951620}{Imbens and Angrist (1994)} and
\href{https://doi.org/10.1111/j.1468-0262.2005.00594.x}{Heckman and Vytlacil
(2005)}. The framework on which this function is based was developed by
\href{https://doi.org/10.3982/ECTA15463}{Mogstad, Santos and Torgovitsky
(2018)}. See also the recent survey paper on extrapolation in IV models by
\href{https://doi.org/10.1146/annurev-economics-101617-041813}{Mogstad and
Torgovitsky (2018)}.
}
\examples{
ivlikespecs <- c(ey ~ d | z,
                 ey ~ d | factor(z),
                 ey ~ d,
                 ey ~ d | factor(z))
jvec <- l(d, d, d, d)
svec <- l(, , , z \%in\% c(2, 4))

ivmte(ivlike = ivlikespecs,
      data = dtm,
      components = jvec,
      propensity = d ~ z,
      subset = svec,
      m0 = ~  u + I(u ^ 2),
      m1 = ~  u + I(u ^ 2),
      uname = u,
      target = "att",
      m0.dec = TRUE,
      m1.dec = TRUE,
      bootstraps = 0,
      lpsolver = "lpSolveAPI")

}
