% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lp.R
\name{optionsGurobi}
\alias{optionsGurobi}
\title{Function to parse options for Gurobi}
\usage{
optionsGurobi(options, debug)
}
\arguments{
\item{options}{list. The list should be structured the same way as
if one were using the \code{gurobi} library directly. That is,
the name of each item must be the name of the option, and is
case sensitive. The value assigned to each item is the value to
set the option to.}

\item{debug}{boolean, indicates whether or not the function should
provide output when obtaining bounds. The option is only
applied when \code{lpsolver = 'gurobi'}. The output provided is
the same as what the Gurobi API would send to the console.}
}
\value{
list, the set of options declared by the user, including
    some additional default values (if not assigned by the user)
    and accounting for \code{debug}.
}
\description{
This function constructs a list of options to be parsed when
\code{lpsolver} is set to \code{Gurobi}. This function really
implements some default values, and accounts for the \code{debug}
option.
}
