% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haps_functions.R
\name{haps_functions}
\alias{haps_functions}
\title{Organize higher-level information for creating haplotypes.}
\description{
The following functions organize information that gets passed to \code{create_haplotypes}
to generate haplotypes from a reference genome.
Each function represents a method of generation and starts with \code{"haps_"}.
The first three are phylogenomic methods, and all functions but \code{haps_vcf}
will use molecular evolution information when passed to \code{create_haplotypes}.
}
\details{
\describe{
\item{\code{\link{haps_theta}}}{Uses an estimate for theta, the population-scaled
mutation rate, and a desired number of haplotypes.}
\item{\code{\link{haps_phylo}}}{Uses phylogenetic tree(s) from \code{phylo}
object(s) or NEWICK file(s), one tree per chromosome or one for all
chromosomes.}
\item{\code{\link{haps_gtrees}}}{Uses gene trees, either in the form of
an object from the \code{scrm} or \code{coala} package or
a file containing output in the style of the \code{ms} program.}
\item{\code{\link{haps_ssites}}}{Uses matrices of segregating sites,
either in the form of
\code{scrm} or \code{coala} coalescent-simulator object(s), or
a \code{ms}-style output file.}
\item{\code{\link{haps_vcf}}}{Uses a haplotype call format (VCF) file that
directly specifies haplotypes.}
}
}
\seealso{
\code{\link{create_haplotypes}}
}
