% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstraw_pam.R
\name{jackstraw_pam}
\alias{jackstraw_pam}
\title{Non-Parametric Jackstraw for Partitioning Around Medoids (PAM)}
\usage{
jackstraw_pam(dat, pam.dat, s = NULL, B = NULL, center = TRUE,
  covariate = NULL, verbose = FALSE, pool = TRUE, seed = NULL, ...)
}
\arguments{
\item{dat}{a matrix with \code{m} rows as variables and \code{n} columns as observations.}

\item{pam.dat}{an output from applying \code{cluster::pam()} on \code{dat}.}

\item{s}{a number of ``synthetic'' null variables. Out of \code{m} variables, \code{s} variables are independently permuted.}

\item{B}{a number of resampling iterations.}

\item{center}{a logical specifying to center the rows. By default, \code{TRUE}.}

\item{covariate}{a model matrix of covariates with \code{n} observations. Must include an intercept in the first column.}

\item{verbose}{a logical specifying to print the computational progress. By default, \code{FALSE}.}

\item{pool}{a logical specifying to pool the null statistics across all clusters. By default, \code{TRUE}.}

\item{seed}{a seed for the random number generator.}

\item{...}{optional arguments to control the k-means clustering algorithm (refers to \code{kmeans}).}
}
\value{
\code{jackstraw_pam} returns a list consisting of
\item{F.obs}{\code{m} observed F statistics between variables and cluster medoids.}
\item{F.null}{F null statistics between null variables and cluster medoids, from the jackstraw method.}
\item{p.F}{\code{m} p-values of membership.}
}
\description{
Test the cluster membership for Partitioning Around Medoids (PAM)
}
\details{
PAM assigns \code{m} rows into \code{K} clusters. This function enable statistical
evaluation if the cluster membership is correctly assigned. Each of \code{m} p-values refers to
the statistical test of that row with regard to its assigned cluster.
Its resampling strategy accounts for the over-fitting characteristics due to direct computation of clusters from the observed data
and protects against an anti-conservative bias.

For a large dataset, PAM could be too slow. Consider using \code{cluster::clara} and \code{jackstraw::jackstraw_clara}.

The input data (\code{dat}) must be of a class `matrix`.
}
\examples{
\dontrun{
library(cluster)
set.seed(1234)
dat = t(scale(t(Jurkat293T), center=TRUE, scale=FALSE))
pam.dat <- pam(dat, k=2)
jackstraw.out <- jackstraw_pam(dat, pam.dat = pam.dat)
}
}
\references{
Chung (2018) Statistical significance for cluster membership. biorxiv, doi:10.1101/248633 \url{https://www.biorxiv.org/content/early/2018/01/16/248633}
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
