% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p-weierstrass.R
\name{wp}
\alias{wp}
\title{Weierstrass elliptic function}
\usage{
wp(z, g = NULL, omega = NULL, derivative = 0L)
}
\arguments{
\item{z}{complex number}

\item{g}{the elliptic invariants, a vector of two complex numbers; they are 
related to the half-periods (\code{omega}) and only one of \code{g} 
and \code{omega} must be given}

\item{omega}{the half-periods, a vector of two complex numbers; they are 
related to the elliptic invariants (\code{g}) and only one of \code{g} 
and \code{omega} must be given}

\item{derivative}{differentiation order, an integer between 0 and 3}
}
\value{
A complex number.
}
\description{
Evaluation of the Weierstrass elliptic function and its 
  derivatives.
}
\examples{
omega1 <- 1.4 - 1i
omega2 <- 1.6 + 0.5i
omega <- c(omega1, omega2)
e1 <- wp(omega1, omega = omega)
e2 <- wp(omega2, omega = omega)
e3 <- wp(-omega1-omega2, omega = omega)
e1 + e2 + e3 # should be 0
}
