% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conformalMaps.R
\name{disk2H}
\alias{disk2H}
\title{Disk to upper half-plane}
\usage{
disk2H(z)
}
\arguments{
\item{z}{a complex number in the unit disk}
}
\value{
A complex number in the upper half-plane.
}
\description{
Conformal map from the unit disk to the upper half-plane. 
  The function is vectorized.
}
\examples{
# map the disk to H and calculate kleinj
f <- function(x, y) {
  z <- complex(real = x, imaginary = y)
  K <- rep(NA_complex_, length(x))
  inDisk <- Mod(z) < 1
  K[inDisk] <- kleinj(disk2H(z[inDisk]))
  K
}
n <- 1024L
x <- y <- seq(-1, 1, length.out = n)
Grid <- expand.grid(X = x, Y = y)
\donttest{K <- f(Grid$X, Grid$Y)
dim(K) <- c(n, n)
# plot
if(require("RcppColors")) {
  img <- colorMap5(K)
} else {
  img <- as.raster(1 - abs(Im(K))/Mod(K))
}
opar <- par(mar = c(0, 0, 0, 0))
plot(NULL, xlim = c(0, 1), ylim = c(0, 1), asp = 1, 
     axes = FALSE, xaxs = "i", yaxs = "i", xlab = NA, ylab = NA)
rasterImage(img, 0, 0, 1, 1)
par(opar)}
}
