% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{col2alpha}
\alias{col2alpha}
\title{get R color alpha value}
\usage{
col2alpha(x, maxValue = 1, ...)
}
\arguments{
\item{x}{\code{character} R compatible color, either a color name, hex value, or
a mixture of the two. Any value compatible with \code{grDevices::col2rgb()}.}

\item{maxValue}{\code{numeric} maximum value to return, useful when the downstream
alpha range should be 255. By default maxValue=1 is returned.}

\item{...}{Additional arguments are ignored.}
}
\value{
\code{numeric} vector of alpha values
}
\description{
Return the alpha transparency per R color
}
\examples{
col2alpha(c("red", "#99004499", "beige", "transparent", "#FFFFFF00"))

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{rgb2col}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
