# Copyright (C) 2020-2023 Koen Derks

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

#' Sino Forest Corporation's Financial Statements.
#'
#' Financial statement numbers of Sino Forest Corporation's 2010 Report.
#'
#' @docType data
#'
#' @usage data(sinoForest)
#'
#' @format A data frame with 772 rows and 1 variable.
#'
#' @keywords datasets
#'
#' @references Nigrini, M. J. (2012). Benford's Law: Application for Forensic
#' Accounting, Auditing and Fraud Detection. Wiley and Sons: New Jersey.
#'
#' @source \url{https://cran.r-project.org/package=benford.analysis}
#'
#' @examples
#' data(sinoForest)
"sinoForest"
