% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annoPoint2.R
\name{annoPoint2}
\alias{annoPoint2}
\title{annoPoint2}
\arguments{
\item{object}{Your ggplot list. Default(NULL).}

\item{relSideDist}{The relative distance ratio to the y axis range. Default(0.1).}

\item{aesGroup}{Whether use your group column to add rect annotation. Default("FALSE").}

\item{aesShape}{Whether force the point shape mapping to the aesGroName. Default("FALSE").}

\item{aesGroName}{The mapping column name. Default(NULL).}

\item{annoPos}{The position for the annotation to be added. Default("top").}

\item{xPosition}{The x axis coordinate for the points. Default(NULL).}

\item{yPosition}{The y axis coordinate for the points. Default(NULL).}

\item{pCol}{The point colors. Default(NULL).}

\item{pFill}{The point fill colors. Default(NULL).}

\item{ptSize}{The point size. Default(3).}

\item{ptShape}{The point shape. Default(NULL).}

\item{annoManual}{Whether annotate by yourself by supplying with x and y coordinates. Default(FALSE).}

\item{addText}{Whether add text label on segment. Default(FALSE).}

\item{textCol}{The text colors. Default(NULL).}

\item{textSize}{The text size. Default(NULL).}

\item{fontfamily}{The text fontfamily. Default(NULL).}

\item{fontface}{The text fontface. Default(NULL).}

\item{textLabel}{The text textLabel. Default(NULL).}

\item{textRot}{The text angle. Default(NULL).}

\item{textHVjust}{The text distance from the segment. Default(0.2).}

\item{hjust}{The text hjust. Default(NULL).}

\item{vjust}{The text vjust. Default(NULL).}

\item{myFacetGrou}{Your facet group name to be added with annotation when object is a faceted object. Default(NULL).}

\item{aes_x}{= NULL You should supply the plot X mapping name when annotate a facetd plot. Default(NULL).}

\item{aes_y}{= NULL You should supply the plot Y mapping name when annotate a facetd plot. Default(NULL).}
}
\value{
Return a ggplot object.
}
\description{
This function is used to add points annotations in plot.
}
\examples{
# ===============================
# test function
data(p)

# default plot
annoPoint2(object = p,
          annoPos = 'top',
          xPosition = c(1:10))

# change relative distance
annoPoint2(object = p,
          annoPos = 'top',
          xPosition = c(1:10),
          relSideDist = 0)

# specify yPosition
annoPoint2(object = p,
          annoPos = 'top',
          xPosition = c(1:10),
          yPosition = rep(c(2,4,2,6,4),each = 2))

# add right
annoPoint2(object = p,
          annoPos = 'right',
          yPosition = c(1:10))

# left
annoPoint2(object = p,
          annoPos = 'left',
          yPosition = c(1:10))

# supply xPosition to ajust
annoPoint2(object = p,
          annoPos = 'right',
          yPosition = c(1:10),
          xPosition = 0.3)

# change point size and shape
p1 <- annoPoint2(object = p,
                annoPos = 'top',
                xPosition = c(1:10),
                ptSize = 2,
                ptShape = 25)

# add to right
annoPoint2(object = p1,
          annoPos = 'right',
          yPosition = c(1:10),
          ptSize = 2,
          ptShape = 23)

# add manually
annoPoint2(object = p,
          annoPos = 'right',
          annoManual = TRUE,
          yPosition = c(1:10),
          xPosition = c(1:10))
}
\author{
Junjun Lao
}
