% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jl_-model.R
\name{jl-helpers-model}
\alias{jl-helpers-model}
\alias{jl_formula}
\alias{jl_contrasts}
\alias{jl_data}
\alias{jl_family}
\title{Helpers for converting model specifications in R to Julia equivalents}
\usage{
jl_formula(formula)

jl_contrasts(df, cols = NULL, show_code = FALSE)

jl_data(df)

jl_family(family = c("gaussian", "binomial", "poisson"))
}
\arguments{
\item{formula}{A string or formula object}

\item{df}{A data frame}

\item{cols}{A subset of columns to make contrast specifiations for}

\item{show_code}{Whether to print corresponding Julia code as a side-effect}

\item{family}{The distributional family as string or \verb{<family>} object}
}
\value{
A Julia object of type \verb{<JuliaProxy>}
}
\description{
Helpers for converting model specifications in R to Julia equivalents
}
\examples{
\dontshow{if (check_julia_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
jlme_setup(restart = TRUE)

# Set up model data in R
x <- mtcars
x$cyl_helm <- factor(x$cyl)
contrasts(x$cyl_helm) <- contr.helmert(3)
colnames(contrasts(x$cyl_helm)) <- c("4vs6", "4&6vs8")

# Formula conversion with
julia_formula <- jl_formula(mpg ~ am * cyl_helm)
julia_formula

# Data frame conversion
julia_data <- jl_data(x)
julia_data

# Contrasts construction (`show_code = TRUE` pretty prints the Julia code)
julia_contrasts <- jl_contrasts(x, show_code = TRUE)
julia_contrasts

# Family conversion
julia_family <- jl_family("binomial")
julia_family

stop_julia()
}
\dontshow{\}) # examplesIf}
}
\keyword{internal}
