% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parametricbootstrap.R
\name{parametricbootstrap}
\alias{parametricbootstrap}
\title{Parametric bootstrap for Julia mixed effects models}
\usage{
parametricbootstrap(
  x,
  nsim,
  seed,
  ...,
  optsum_overrides = list(ftol_rel = 1e-08)
)
}
\arguments{
\item{x}{A Julia MixedModel of class \code{jlme}}

\item{nsim}{Number of simulations}

\item{seed}{Seed for the random number generator (Random.MersenneTwister)}

\item{...}{Not implemented}

\item{optsum_overrides}{Values to override in the OptSummary.}
}
\value{
MixedModels.parametricboostrap() output as object of class \code{jlmeboot}
}
\description{
Parametric bootstrap for Julia mixed effects models
}
\examples{
\donttest{
jlme_setup(restart = TRUE)

jmod <- jlmer(Reaction ~ Days + (Days | Subject), lme4::sleepstudy)
tidy(jmod)

samp <- parametricbootstrap(jmod, nsim = 100L, seed = 42L)
samp

tidy(samp)

stop_julia()
}
}
