summary.jmec <- function(object, ...){
	message("Joint model for event and censoring, linked through cluster-level frailties")
	message("fitted using jmec()")
	message("")
	message("Model formula for event:")
	print(object$formula.T)
	message("Model formula for censoring:")
	print(object$formula.C)
	message("")
	message("Cluster ID:")
	message(object$clustid)
	message("")
	message("Parameter estimates (original scale)")
	print(object$par.descr[,c("effect", "coef", "se.coef", "z", "p", "coef.lower.95", "coef.upper.95")])
	message("")
	message("Parameter estimates (HR scale)")
	print(object$par.descr[,c("effect", "HR", "HR.lower.95", "HR.upper.95")])
	message("")
}
