% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conttables.h.R
\name{contTables}
\alias{contTables}
\title{Contingency Tables}
\usage{
contTables(data, rows, cols, counts = NULL, layers = NULL, chiSq = TRUE,
  chiSqCorr = FALSE, likeRat = FALSE, contCoef = FALSE, phiCra = FALSE,
  logOdds = FALSE, ciWidth = 95, gamma = FALSE, taub = FALSE,
  exp = FALSE, pcRow = FALSE, pcCol = FALSE, pcTot = FALSE)
}
\arguments{
\item{data}{the data as a data frame}

\item{rows}{a string naming the variable to use as the rows in the 
contingency table}

\item{cols}{a string naming the variable to use as the columns in the 
contingency table}

\item{counts}{a string naming the variable to use as counts, or NULL if 
each row represents a single observation}

\item{layers}{a character vector naming variables to split the contingency 
table across}

\item{chiSq}{\code{TRUE} (default) or \code{FALSE}, provide chi²}

\item{chiSqCorr}{\code{TRUE} or \code{FALSE} (default), provide chi² with 
continuity correction}

\item{likeRat}{\code{TRUE} or \code{FALSE} (default), provide the 
likelihood ratio}

\item{contCoef}{\code{TRUE} or \code{FALSE} (default), provide the 
contingency coefficient}

\item{phiCra}{\code{TRUE} or \code{FALSE} (default), provide Phi and 
Cramer's V}

\item{logOdds}{\code{TRUE} or \code{FALSE} (default), provide the log odds 
ratio (only available for 2x2 tables)}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), width of the 
confidence intervals to provide}

\item{gamma}{\code{TRUE} or \code{FALSE} (default), provide gamma}

\item{taub}{\code{TRUE} or \code{FALSE} (default), provide Kendall's tau-b}

\item{exp}{\code{TRUE} or \code{FALSE} (default), provide the expected 
counts}

\item{pcRow}{\code{TRUE} or \code{FALSE} (default), provide row percentages}

\item{pcCol}{\code{TRUE} or \code{FALSE} (default), provide column 
percentages}

\item{pcTot}{\code{TRUE} or \code{FALSE} (default), provide total 
percentages}
}
\description{
chi² test of association
}
\examples{
\dontrun{
contTables(data, rows='x', cols='y')
}
}

