% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrmatrix.h.R
\name{corrMatrix}
\alias{corrMatrix}
\title{Correlation Matrix}
\usage{
corrMatrix(data, vars, pearson = TRUE, spearman = FALSE, kendall = FALSE,
  sig = TRUE, flag = FALSE, ci = FALSE, ciWidth = 95, plots = FALSE,
  plotDens = FALSE, plotStats = FALSE, hypothesis = "corr")
}
\arguments{
\item{data}{the data as a data frame}

\item{vars}{a vector of strings naming the variables to correlate in 
\code{data}}

\item{pearson}{\code{TRUE} (default) or \code{FALSE}, provide Pearson's R}

\item{spearman}{\code{TRUE} or \code{FALSE} (default), provide Spearman's 
rho}

\item{kendall}{\code{TRUE} or \code{FALSE} (default), provide Kendall's 
tau-b}

\item{sig}{\code{TRUE} (default) or \code{FALSE}, provide significance 
levels}

\item{flag}{\code{TRUE} or \code{FALSE} (default), flag significant 
correlations}

\item{ci}{\code{TRUE} or \code{FALSE} (default), provide confidence 
intervals}

\item{ciWidth}{a number between 50 and 99.9 (default: 95), the width of 
confidence intervals to provide}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide a correlation 
matrix plot}

\item{plotDens}{\code{TRUE} or \code{FALSE} (default), provide densities in 
the correlation matrix plot}

\item{plotStats}{\code{TRUE} or \code{FALSE} (default), provide statistics 
in the correlation matrix plot}

\item{hypothesis}{one of \code{'corr'} (default), \code{'pos'}, 
\code{'neg'} specifying the alernative hypothesis; correlated, correlated 
positively, correlated negatively respectively.}
}
\description{
Correlation Matrix
}
\examples{
\dontrun{
corrMatrix(data, vars=c('x', 'y', 'z'))
}
}

