
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
reliabilityOptions <- R6::R6Class(
    "reliabilityOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            alphaScale = TRUE,
            omegaScale = FALSE,
            meanScale = FALSE,
            sdScale = FALSE,
            corPlot = FALSE,
            alphaItems = FALSE,
            omegaItems = FALSE,
            meanItems = FALSE,
            sdItems = FALSE,
            itemRestCor = FALSE, ...) {

            super$initialize(
                package='jmv',
                name='reliability',
                requiresData=TRUE,
                ...)
        
            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "ordinal",
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"),
                rejectInf=FALSE)
            private$..alphaScale <- jmvcore::OptionBool$new(
                "alphaScale",
                alphaScale,
                default=TRUE)
            private$..omegaScale <- jmvcore::OptionBool$new(
                "omegaScale",
                omegaScale,
                default=FALSE)
            private$..meanScale <- jmvcore::OptionBool$new(
                "meanScale",
                meanScale,
                default=FALSE)
            private$..sdScale <- jmvcore::OptionBool$new(
                "sdScale",
                sdScale,
                default=FALSE)
            private$..corPlot <- jmvcore::OptionBool$new(
                "corPlot",
                corPlot,
                default=FALSE)
            private$..alphaItems <- jmvcore::OptionBool$new(
                "alphaItems",
                alphaItems,
                default=FALSE)
            private$..omegaItems <- jmvcore::OptionBool$new(
                "omegaItems",
                omegaItems,
                default=FALSE)
            private$..meanItems <- jmvcore::OptionBool$new(
                "meanItems",
                meanItems,
                default=FALSE)
            private$..sdItems <- jmvcore::OptionBool$new(
                "sdItems",
                sdItems,
                default=FALSE)
            private$..itemRestCor <- jmvcore::OptionBool$new(
                "itemRestCor",
                itemRestCor,
                default=FALSE)
        
            self$.addOption(private$..vars)
            self$.addOption(private$..alphaScale)
            self$.addOption(private$..omegaScale)
            self$.addOption(private$..meanScale)
            self$.addOption(private$..sdScale)
            self$.addOption(private$..corPlot)
            self$.addOption(private$..alphaItems)
            self$.addOption(private$..omegaItems)
            self$.addOption(private$..meanItems)
            self$.addOption(private$..sdItems)
            self$.addOption(private$..itemRestCor)
        }),
    active = list(
        vars = function() private$..vars$value,
        alphaScale = function() private$..alphaScale$value,
        omegaScale = function() private$..omegaScale$value,
        meanScale = function() private$..meanScale$value,
        sdScale = function() private$..sdScale$value,
        corPlot = function() private$..corPlot$value,
        alphaItems = function() private$..alphaItems$value,
        omegaItems = function() private$..omegaItems$value,
        meanItems = function() private$..meanItems$value,
        sdItems = function() private$..sdItems$value,
        itemRestCor = function() private$..itemRestCor$value),
    private = list(
        ..vars = NA,
        ..alphaScale = NA,
        ..omegaScale = NA,
        ..meanScale = NA,
        ..sdScale = NA,
        ..corPlot = NA,
        ..alphaItems = NA,
        ..omegaItems = NA,
        ..meanItems = NA,
        ..sdItems = NA,
        ..itemRestCor = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
reliabilityResults <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        scale = function() private$..scale,
        items = function() private$..items,
        corPlot = function() private$..corPlot),
    private = list(
        ..scale = NA,
        ..items = NA,
        ..corPlot = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Reliability Analysis")
            private$..scale <- jmvcore::Table$new(
                options=options,
                name="scale",
                title="Scale Reliability Statistics",
                rows=1,
                clearWith=list(
                    "vars"),
                columns=list(
                    list(`name`="name", `title`="", `type`="text", `content`="scale"),
                    list(`name`="mean", `title`="mean", `visible`="(meanScale)"),
                    list(`name`="sd", `title`="sd", `visible`="(sdScale)"),
                    list(`name`="alpha", `title`="Cronbach's \u03B1", `visible`="(alphaScale)"),
                    list(`name`="omega", `title`="McDonald's \u03C9", `visible`="(omegaScale)")))
            private$..items <- jmvcore::Table$new(
                options=options,
                name="items",
                title="Item Reliability Statistics",
                visible="(meanItems || sdItems || itemRestCor || alphaItems || omegaItems)",
                rows="(vars)",
                clearWith=list(
                    "vars"),
                columns=list(
                    list(`name`="name", `title`="", `type`="text", `content`="($key)"),
                    list(`name`="mean", `title`="mean", `visible`="(meanItems)"),
                    list(`name`="sd", `title`="sd", `visible`="(sdItems)"),
                    list(`name`="itemRestCor", `title`="item-rest correlation", `visible`="(itemRestCor)"),
                    list(`name`="alpha", `title`="Cronbach's \u03B1", `visible`="(alphaItems)"),
                    list(`name`="omega", `title`="McDonald's \u03C9", `visible`="(omegaItems)")))
            private$..corPlot <- jmvcore::Image$new(
                options=options,
                name="corPlot",
                title="Correlation Plot",
                visible="(corPlot)",
                width=400,
                height=400,
                renderFun=".corPlot",
                clearWith=list(
                    "vars"))
            self$add(private$..scale)
            self$add(private$..items)
            self$add(private$..corPlot)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
reliabilityBase <- R6::R6Class(
    "reliabilityBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'reliability',
                version = c(1,0,0),
                options = options,
                results = reliabilityResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL)
        }))

#' Reliability Analysis
#'
#' 
#' @param data the data as a data frame
#' @param vars a vector of strings naming the variables of interest in 
#'   \code{data}
#' @param alphaScale \code{TRUE} (default) or \code{FALSE}, provide Cronbach's 
#'   alpha 
#' @param omegaScale \code{TRUE} or \code{FALSE} (default), provide McDonald's 
#'   omega 
#' @param meanScale \code{TRUE} or \code{FALSE} (default), provide the mean 
#' @param sdScale \code{TRUE} or \code{FALSE} (default), provide the standard 
#'   deviation 
#' @param corPlot \code{TRUE} or \code{FALSE} (default), provide a correlation 
#'   plot 
#' @param alphaItems \code{TRUE} or \code{FALSE} (default), provide what the 
#'   Cronbach's alpha would be if the item was dropped 
#' @param omegaItems \code{TRUE} or \code{FALSE} (default), provide what the 
#'   McDonald's omega would be if the item was dropped 
#' @param meanItems \code{TRUE} or \code{FALSE} (default), provide item means 
#' @param sdItems \code{TRUE} or \code{FALSE} (default), provide item standard 
#'   deviations 
#' @param itemRestCor \code{TRUE} or \code{FALSE} (default), provide item-rest 
#'   correlations 
#' @export
reliability <- function(
    data,
    vars,
    alphaScale = TRUE,
    omegaScale = FALSE,
    meanScale = FALSE,
    sdScale = FALSE,
    corPlot = FALSE,
    alphaItems = FALSE,
    omegaItems = FALSE,
    meanItems = FALSE,
    sdItems = FALSE,
    itemRestCor = FALSE) {

    options <- reliabilityOptions$new(
        vars = vars,
        alphaScale = alphaScale,
        omegaScale = omegaScale,
        meanScale = meanScale,
        sdScale = sdScale,
        corPlot = corPlot,
        alphaItems = alphaItems,
        omegaItems = omegaItems,
        meanItems = meanItems,
        sdItems = sdItems,
        itemRestCor = itemRestCor)

    results <- reliabilityResults$new(
        options = options)

    analysis <- reliabilityClass$new(
        options = options,
        data = data)

    analysis$run()
    analysis$render()

    analysis
}
