
# This file is automatically generated, you probably don't want to edit this

#' @importFrom jmvcore Options
#' @importFrom R6 R6Class
propTest2Options <- R6::R6Class(
    "propTest2Options",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            areCounts = FALSE,
            testValue = 0.5,
            hypothesis = "notequal",
            ci = FALSE,
            ciWidth = 95, ...) {

            super$initialize(
                package='jmv',
                name='propTest2',
                requiresData=TRUE,
                ...)
        
            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "nominal",
                    "ordinal"))
            private$..areCounts <- jmvcore::OptionBool$new(
                "areCounts",
                areCounts,
                default=FALSE)
            private$..testValue <- jmvcore::OptionNumber$new(
                "testValue",
                testValue,
                default=0.5)
            private$..hypothesis <- jmvcore::OptionList$new(
                "hypothesis",
                hypothesis,
                options=list(
                    "notequal",
                    "greater",
                    "less"),
                default="notequal")
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
        
            self$.addOption(private$..vars)
            self$.addOption(private$..areCounts)
            self$.addOption(private$..testValue)
            self$.addOption(private$..hypothesis)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
        }),
    active = list(
        vars = function() private$..vars$value,
        areCounts = function() private$..areCounts$value,
        testValue = function() private$..testValue$value,
        hypothesis = function() private$..hypothesis$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value),
    private = list(
        ..vars = NA,
        ..areCounts = NA,
        ..testValue = NA,
        ..hypothesis = NA,
        ..ci = NA,
        ..ciWidth = NA)
)

#' @import jmvcore
#' @importFrom R6 R6Class
propTest2Results <- R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        table = function() private$..table),
    private = list(
        ..table = NA),
    public=list(
        initialize=function(options) {
            super$initialize(options=options, name="", title="Proportion Test (2 Outcomes)")
            private$..table <- jmvcore::Table$new(
                options=options,
                name="table",
                title="Binomial Test",
                clearWith=list(
                    "areCounts",
                    "testValue",
                    "hypothesis",
                    "ciWidth"),
                columns=list(
                    list(`name`="var", `title`="", `type`="text", `combineBelow`=TRUE),
                    list(`name`="level", `title`="Level", `type`="text"),
                    list(`name`="count", `title`="Count", `type`="integer"),
                    list(`name`="total", `title`="Total", `type`="integer"),
                    list(`name`="prop", `title`="Proportion", `type`="number", `format`="zto"),
                    list(`name`="p", `title`="p", `type`="number", `format`="zto,pvalue"),
                    list(`name`="cil", `title`="Lower", `superTitle`="Confidence Interval", `type`="number", `visible`="(ci)"),
                    list(`name`="ciu", `title`="Upper", `superTitle`="Confidence Interval", `type`="number", `visible`="(ci)")))
            self$add(private$..table)}))

#' @importFrom jmvcore Analysis
#' @importFrom R6 R6Class
propTest2Base <- R6::R6Class(
    "propTest2Base",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'propTest2',
                version = c(1,0,0),
                options = options,
                results = propTest2Results$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE)
        }))

#' Proportion Test (2 Outcomes)
#'
#' Binomial test
#'
#' @examples
#' \dontrun{
#' dat <- data.frame(x=c(8, 15))
#' 
#' propTest2(dat, vars = 'x', areCounts = TRUE)
#' 
#' #
#' #  Binomial Test
#' #  -------------------------------------------------------
#' #         Level    Count    Total    Proportion    p
#' #  -------------------------------------------------------
#' #    x    1            8       23         0.348    0.210
#' #         2           15       23         0.652    0.210
#' #  -------------------------------------------------------
#' #    Note. Ha is proportion != 0.5
#' #
#' }
#' @param data the data as a data frame
#' @param vars a vector of strings naming the variables of interest in 
#'   \code{data}
#' @param areCounts \code{TRUE} or \code{FALSE} (default), the variables are 
#'   counts 
#' @param testValue a number (default: 0.5), the value for the null hypothesis 
#' @param hypothesis \code{'notequal'} (default), \code{'greater'} or 
#'   \code{'less'}, the alternative hypothesis 
#' @param ci \code{TRUE} or \code{FALSE} (default), provide confidence 
#'   intervals 
#' @param ciWidth a number between 50 and 99.9 (default: 95), the confidence 
#'   interval width 
#' @export
propTest2 <- function(
    data,
    vars,
    areCounts = FALSE,
    testValue = 0.5,
    hypothesis = "notequal",
    ci = FALSE,
    ciWidth = 95) {

    options <- propTest2Options$new(
        vars = vars,
        areCounts = areCounts,
        testValue = testValue,
        hypothesis = hypothesis,
        ci = ci,
        ciWidth = ciWidth)

    results <- propTest2Results$new(
        options = options)

    analysis <- propTest2Class$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
