
# This file is automatically generated, you probably don't want to edit this

mancovaOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "mancovaOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            deps = NULL,
            factors = NULL,
            covs = NULL,
            multivar = list(
                "pillai",
                "wilks",
                "hotel",
                "roy"),
            boxM = FALSE,
            shapiro = FALSE,
            qqPlot = FALSE, ...) {

            super$initialize(
                package='jmv',
                name='mancova',
                requiresData=TRUE,
                ...)

            private$..deps <- jmvcore::OptionVariables$new(
                "deps",
                deps,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"))
            private$..factors <- jmvcore::OptionVariables$new(
                "factors",
                factors,
                rejectUnusedLevels=TRUE,
                suggested=list(
                    "nominal",
                    "ordinal"),
                permitted=list(
                    "factor"),
                default=NULL)
            private$..covs <- jmvcore::OptionVariables$new(
                "covs",
                covs,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"),
                default=NULL)
            private$..multivar <- jmvcore::OptionNMXList$new(
                "multivar",
                multivar,
                options=list(
                    "pillai",
                    "wilks",
                    "hotel",
                    "roy"),
                default=list(
                    "pillai",
                    "wilks",
                    "hotel",
                    "roy"))
            private$..boxM <- jmvcore::OptionBool$new(
                "boxM",
                boxM,
                default=FALSE)
            private$..shapiro <- jmvcore::OptionBool$new(
                "shapiro",
                shapiro,
                default=FALSE)
            private$..qqPlot <- jmvcore::OptionBool$new(
                "qqPlot",
                qqPlot,
                default=FALSE)

            self$.addOption(private$..deps)
            self$.addOption(private$..factors)
            self$.addOption(private$..covs)
            self$.addOption(private$..multivar)
            self$.addOption(private$..boxM)
            self$.addOption(private$..shapiro)
            self$.addOption(private$..qqPlot)
        }),
    active = list(
        deps = function() private$..deps$value,
        factors = function() private$..factors$value,
        covs = function() private$..covs$value,
        multivar = function() private$..multivar$value,
        boxM = function() private$..boxM$value,
        shapiro = function() private$..shapiro$value,
        qqPlot = function() private$..qqPlot$value),
    private = list(
        ..deps = NA,
        ..factors = NA,
        ..covs = NA,
        ..multivar = NA,
        ..boxM = NA,
        ..shapiro = NA,
        ..qqPlot = NA)
)

mancovaResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        multivar = function() private$.items[["multivar"]],
        univar = function() private$.items[["univar"]],
        assump = function() private$.items[["assump"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="MANCOVA")
            self$add(jmvcore::Table$new(
                options=options,
                name="multivar",
                title="Multivariate Tests",
                clearWith=list(
                    "deps",
                    "factors",
                    "covs"),
                columns=list(
                    list(
                        `name`="term[pillai]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(multivar:pillai)"),
                    list(
                        `name`="test[pillai]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Pillai's Trace", 
                        `visible`="(multivar:pillai)"),
                    list(
                        `name`="stat[pillai]", 
                        `title`="value", 
                        `type`="number", 
                        `visible`="(multivar:pillai)"),
                    list(
                        `name`="f[pillai]", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(multivar:pillai)"),
                    list(
                        `name`="df1[pillai]", 
                        `title`="df1", 
                        `type`="integer", 
                        `visible`="(multivar:pillai)"),
                    list(
                        `name`="df2[pillai]", 
                        `title`="df2", 
                        `type`="integer", 
                        `visible`="(multivar:pillai)"),
                    list(
                        `name`="p[pillai]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(multivar:pillai)"),
                    list(
                        `name`="term[wilks]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(multivar:wilks)"),
                    list(
                        `name`="test[wilks]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Wilks' Lambda", 
                        `visible`="(multivar:wilks)"),
                    list(
                        `name`="stat[wilks]", 
                        `title`="value", 
                        `type`="number", 
                        `visible`="(multivar:wilks)"),
                    list(
                        `name`="f[wilks]", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(multivar:wilks)"),
                    list(
                        `name`="df1[wilks]", 
                        `title`="df1", 
                        `type`="integer", 
                        `visible`="(multivar:wilks)"),
                    list(
                        `name`="df2[wilks]", 
                        `title`="df2", 
                        `type`="integer", 
                        `visible`="(multivar:wilks)"),
                    list(
                        `name`="p[wilks]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(multivar:wilks)"),
                    list(
                        `name`="term[hotel]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(multivar:hotel)"),
                    list(
                        `name`="test[hotel]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Hotelling's Trace", 
                        `visible`="(multivar:hotel)"),
                    list(
                        `name`="stat[hotel]", 
                        `title`="value", 
                        `type`="number", 
                        `visible`="(multivar:hotel)"),
                    list(
                        `name`="f[hotel]", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(multivar:hotel)"),
                    list(
                        `name`="df1[hotel]", 
                        `title`="df1", 
                        `type`="integer", 
                        `visible`="(multivar:hotel)"),
                    list(
                        `name`="df2[hotel]", 
                        `title`="df2", 
                        `type`="integer", 
                        `visible`="(multivar:hotel)"),
                    list(
                        `name`="p[hotel]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(multivar:hotel)"),
                    list(
                        `name`="term[roy]", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE, 
                        `visible`="(multivar:roy)"),
                    list(
                        `name`="test[roy]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Roy's Largest Root", 
                        `visible`="(multivar:roy)"),
                    list(
                        `name`="stat[roy]", 
                        `title`="value", 
                        `type`="number", 
                        `visible`="(multivar:roy)"),
                    list(
                        `name`="f[roy]", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(multivar:roy)"),
                    list(
                        `name`="df1[roy]", 
                        `title`="df1", 
                        `type`="integer", 
                        `visible`="(multivar:roy)"),
                    list(
                        `name`="df2[roy]", 
                        `title`="df2", 
                        `type`="integer", 
                        `visible`="(multivar:roy)"),
                    list(
                        `name`="p[roy]", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(multivar:roy)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="univar",
                title="Univariate Tests",
                clearWith=list(
                    "deps",
                    "factors",
                    "covs"),
                columns=list(
                    list(
                        `name`="term", 
                        `title`="", 
                        `type`="text", 
                        `combineBelow`=TRUE),
                    list(
                        `name`="dep", 
                        `title`="Dependent Variable", 
                        `type`="text"),
                    list(
                        `name`="ss", 
                        `title`="Sum of Squares", 
                        `type`="number"),
                    list(
                        `name`="df", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="ms", 
                        `title`="Mean Square", 
                        `type`="number"),
                    list(
                        `name`="F", 
                        `title`="F", 
                        `type`="number"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    boxM = function() private$.items[["boxM"]],
                    shapiro = function() private$.items[["shapiro"]],
                    qqPlot = function() private$.items[["qqPlot"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="assump",
                            title="Assumption Checks")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="boxM",
                            title="Box's Homogeneity of Covariance Matrices Test",
                            visible="(boxM)",
                            rows=1,
                            clearWith=list(
                                "deps",
                                "factors"),
                            columns=list(
                                list(
                                    `name`="chi", 
                                    `title`="\u03C7\u00B2", 
                                    `type`="number"),
                                list(
                                    `name`="df", 
                                    `title`="df", 
                                    `type`="integer"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="shapiro",
                            title="Shapiro-Wilk Multivariate Normality Test",
                            visible="(shapiro)",
                            rows=1,
                            clearWith=list(
                                "deps"),
                            columns=list(
                                list(
                                    `name`="w", 
                                    `title`="W", 
                                    `type`="number"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"))))
                        self$add(jmvcore::Image$new(
                            options=options,
                            name="qqPlot",
                            title="Q-Q Plot Assessing Multivariate Normality",
                            width=450,
                            height=400,
                            renderFun=".qqPlot",
                            visible="(qqPlot)",
                            clearWith=list(
                                "deps")))}))$new(options=options))}))

mancovaBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "mancovaBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'mancova',
                version = c(1,0,0),
                options = options,
                results = mancovaResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' MANCOVA
#'
#' Multivariate Analysis of Covariance
#'
#' @examples
#' data('iris')
#'
#' mancova(data = iris,
#'     deps = c('Sepal.Length', 'Sepal.Width', 'Petal.Length', 'Petal.Width'),
#'     factors = 'Species')
#'
#' #
#' #  MANCOVA
#' #
#' #  Multivariate Tests
#' #  ---------------------------------------------------------------------------
#' #                                     value     F       df1    df2    p
#' #  ---------------------------------------------------------------------------
#' #    Species    Pillai's Trace          1.19    53.5      8    290    < .001
#' #               Wilks' Lambda         0.0234     199      8    288    < .001
#' #               Hotelling's Trace       32.5     581      8    286    < .001
#' #               Roy's Largest Root      32.2    1167      4    145    < .001
#' #  ---------------------------------------------------------------------------
#' #
#' #
#' #  Univariate Tests
#' #  -----------------------------------------------------------------------------------------------
#' #                 Dependent Variable    Sum of Squares    df     Mean Square    F         p
#' #  -----------------------------------------------------------------------------------------------
#' #    Species      Sepal.Length                   63.21      2        31.6061     119.3    < .001
#' #                 Sepal.Width                    11.34      2         5.6725      49.2    < .001
#' #                 Petal.Length                  437.10      2       218.5514    1180.2    < .001
#' #                 Petal.Width                    80.41      2        40.2067     960.0    < .001
#' #    Residuals    Sepal.Length                   38.96    147         0.2650
#' #                 Sepal.Width                    16.96    147         0.1154
#' #                 Petal.Length                   27.22    147         0.1852
#' #                 Petal.Width                     6.16    147         0.0419
#' #  -----------------------------------------------------------------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param deps a string naming the dependent variable from \code{data},
#'   variable must be numeric
#' @param factors a vector of strings naming the factors from \code{data}
#' @param covs a vector of strings naming the covariates from \code{data}
#' @param multivar one or more of \code{'pillai'}, \code{'wilks'},
#'   \code{'hotel'}, or \code{'roy'}; use Pillai's Trace, Wilks' Lambda,
#'   Hotelling's Trace, and Roy's Largest Root multivariate statistics,
#'   respectively
#' @param boxM \code{TRUE} or \code{FALSE} (default), provide Box's M test
#' @param shapiro \code{TRUE} or \code{FALSE} (default), provide Shapiro-Wilk
#'   test
#' @param qqPlot \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
#'   multivariate normality
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$multivar} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$univar} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$assump$boxM} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$assump$shapiro} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$assump$qqPlot} \tab \tab \tab \tab \tab an image \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$multivar$asDF}
#'
#' \code{as.data.frame(results$multivar)}
#'
#' @export
mancova <- function(
    data,
    deps,
    factors = NULL,
    covs = NULL,
    multivar = list(
                "pillai",
                "wilks",
                "hotel",
                "roy"),
    boxM = FALSE,
    shapiro = FALSE,
    qqPlot = FALSE) {

    if ( ! requireNamespace('jmvcore'))
        stop('mancova requires jmvcore to be installed (restart may be required)')

    if (missing(data))
        data <- jmvcore:::marshalData(
            parent.frame(),
            `if`( ! missing(deps), deps, NULL),
            `if`( ! missing(factors), factors, NULL),
            `if`( ! missing(covs), covs, NULL))

    for (v in factors) data[[v]] <- as.factor(data[[v]])

    options <- mancovaOptions$new(
        deps = deps,
        factors = factors,
        covs = covs,
        multivar = multivar,
        boxM = boxM,
        shapiro = shapiro,
        qqPlot = qqPlot)

    results <- mancovaResults$new(
        options = options)

    analysis <- mancovaClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
