% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancova.h.R
\name{ancova}
\alias{ancova}
\title{ANCOVA}
\usage{
ancova(data, dep, factors = NULL, covs = NULL, modelTerms = NULL,
  ss = "3", effectSize = NULL, contrasts = NULL, postHoc = NULL,
  postHocCorr = list("tukey"), homo = FALSE, qq = FALSE,
  emMeans = list(list()), ciWidthEmm = 95, emmPlots = TRUE,
  emmPlotData = FALSE, emmPlotError = "ci", emmTables = FALSE,
  emmWeights = TRUE)
}
\arguments{
\item{data}{the data as a data frame}

\item{dep}{a string naming the dependent variable from \code{data},
variable must be numeric}

\item{factors}{a vector of strings naming the fixed factors from
\code{data}}

\item{covs}{a vector of strings naming the covariates from \code{data}}

\item{modelTerms}{a list of character vectors describing the terms to go
into the model}

\item{ss}{\code{'1'}, \code{'2'} or \code{'3'} (default), the sum of
squares to use}

\item{effectSize}{one or more of \code{'eta'}, \code{'partEta'}, or
\code{'omega'}; use eta², partial eta², and omega² effect sizes,
respectively}

\item{contrasts}{a list of lists specifying the factor and type of contrast
to use, one of \code{'deviation'}, \code{'simple'}, \code{'difference'},
\code{'helmert'}, \code{'repeated'} or \code{'polynomial'}}

\item{postHoc}{a list of terms to perform post-hoc tests on}

\item{postHocCorr}{one or more of \code{'none'}, \code{'tukey'},
\code{'scheffe'}, \code{'bonf'}, or \code{'holm'}; provide no, Tukey,
Scheffe, Bonferroni, and Holm Post Hoc corrections respectively}

\item{homo}{\code{TRUE} or \code{FALSE} (default), perform homogeneity
tests}

\item{qq}{\code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
residuals}

\item{emMeans}{a list of lists specifying the variables for which the
estimated marginal means need to be calculate. Supports up to three
variables per term.}

\item{ciWidthEmm}{a number between 50 and 99.9 (default: 95) specifying the
confidence interval width for the estimated marginal means}

\item{emmPlots}{\code{TRUE} (default) or \code{FALSE}, provide estimated
marginal means plots}

\item{emmPlotData}{\code{TRUE} or \code{FALSE} (default), plot the data on
top of the marginal means}

\item{emmPlotError}{\code{'none'}, \code{'ci'} (default), or \code{'se'}.
Use no error bars, use confidence intervals, or use standard errors on the
marginal mean plots, respectively}

\item{emmTables}{\code{TRUE} or \code{FALSE} (default), provide estimated
marginal means tables}

\item{emmWeights}{\code{TRUE} (default) or \code{FALSE}, weigh each cell
equally or weigh them according to the cell frequency}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$main} \tab \tab \tab \tab \tab a table of ANCOVA results \cr
  \code{results$model} \tab \tab \tab \tab \tab The underlying \code{aov} object \cr
  \code{results$assump$homo} \tab \tab \tab \tab \tab a table of homogeneity tests \cr
  \code{results$assump$qq} \tab \tab \tab \tab \tab a q-q plot \cr
  \code{results$contrasts} \tab \tab \tab \tab \tab an array of contrasts tables \cr
  \code{results$postHoc} \tab \tab \tab \tab \tab an array of post-hoc tables \cr
  \code{results$emm} \tab \tab \tab \tab \tab an array of the estimated marginal means plots + tables \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$main$asDF}

\code{as.data.frame(results$main)}
}
\description{
Analysis of Covariance
}
\examples{
data('ToothGrowth')

ancova(ToothGrowth, dep = 'len', factors = 'supp', covs = 'dose')

#
#  ANCOVA
#
#  ANCOVA
#  -----------------------------------------------------------------------
#                 Sum of Squares    df    Mean Square    F        p
#  -----------------------------------------------------------------------
#    supp                    205     1          205.4     11.4     0.001
#    dose                   2224     1         2224.3    124.0    < .001
#    Residuals              1023    57           17.9
#  -----------------------------------------------------------------------
#

}
