% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conttablespaired.h.R
\name{contTablesPaired}
\alias{contTablesPaired}
\title{Paired Samples Contingency Tables}
\usage{
contTablesPaired(
  data,
  rows,
  cols,
  counts = NULL,
  chiSq = TRUE,
  chiSqCorr = FALSE,
  exact = FALSE,
  pcRow = FALSE,
  pcCol = FALSE,
  formula
)
}
\arguments{
\item{data}{the data as a data frame}

\item{rows}{the variable to use as the rows in the contingency table (not
necessary when providing a formula, see the examples)}

\item{cols}{the variable to use as the columns in the contingency table
(not necessary when providing a formula, see the examples)}

\item{counts}{the variable to use as the counts in the contingency table
(not necessary when providing a formula, see the examples)}

\item{chiSq}{\code{TRUE} (default) or \code{FALSE}, provide X²}

\item{chiSqCorr}{\code{TRUE} or \code{FALSE} (default), provide X² with
continuity correction}

\item{exact}{\code{TRUE} or \code{FALSE} (default), provide an exact log
odds ratio (requires exact2x2 to be installed)}

\item{pcRow}{\code{TRUE} or \code{FALSE} (default), provide row percentages}

\item{pcCol}{\code{TRUE} or \code{FALSE} (default), provide column
percentages}

\item{formula}{(optional) the formula to use, see the examples}
}
\value{
A results object containing:
\tabular{llllll}{
  \code{results$freqs} \tab \tab \tab \tab \tab a proportions table \cr
  \code{results$test} \tab \tab \tab \tab \tab a table of test results \cr
}

Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:

\code{results$freqs$asDF}

\code{as.data.frame(results$freqs)}
}
\description{
McNemar test
}
\examples{
dat <- data.frame(
    `1st survey` = c('Approve', 'Approve', 'Disapprove', 'Disapprove'),
    `2nd survey` = c('Approve', 'Disapprove', 'Approve', 'Disapprove'),
    `Counts` = c(794, 150, 86, 570),
    check.names=FALSE)

contTablesPaired(formula = Counts ~ `1st survey`:`2nd survey`, data = dat)

#
#  PAIRED SAMPLES CONTINGENCY TABLES
#
#  Contingency Tables
#  ------------------------------------------------
#    1st survey    Approve    Disapprove    Total
#  ------------------------------------------------
#    Approve           794           150      944
#    Disapprove         86           570      656
#    Total             880           720     1600
#  ------------------------------------------------
#
#
#  McNemar Test
#  -----------------------------------------------------
#                                Value    df    p
#  -----------------------------------------------------
#    X²                           17.4     1    < .001
#    X² continuity correction     16.8     1    < .001
#  -----------------------------------------------------
#


# Alternatively, omit the left of the formula (`Counts`) from the
# formula if each row represents a single observation:

contTablesPaired(formula = ~ `1st survey`:`2nd survey`, data = dat)

}
