% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cv.joinet}
\alias{cv.joinet}
\title{Model comparison}
\usage{
cv.joinet(Y, X, family = "gaussian", nfolds.ext = 5, nfolds.int = 10,
  foldid.ext = NULL, foldid.int = NULL, type.measure = "deviance",
  alpha.base = 1, alpha.meta = 0, mnorm = FALSE, spls = FALSE,
  sier = FALSE, mrce = FALSE, ...)
}
\arguments{
\item{Y}{outputs\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{q} columns (variables),
with positive correlation (see details)}

\item{X}{inputs\strong{:}
numeric matrix with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{family}{distribution\strong{:}
vector of length \eqn{1} or \eqn{q} with entries
\code{"gaussian"}, \code{"binomial"} or \code{"poisson"}}

\item{nfolds.ext}{number of external folds}

\item{nfolds.int}{number of internal folds}

\item{foldid.ext}{external fold identifiers\strong{:}
vector of length \eqn{n} with entries
between \eqn{1} and \code{nfolds.ext};
or \code{NULL}}

\item{foldid.int}{internal fold identifiers\strong{:}
vector of length \eqn{n} with entries
between \eqn{1} and \code{nfolds.int};
or \code{NULL}}

\item{type.measure}{loss function\strong{:}
vector of length \eqn{1} or \eqn{q} with entries
\code{"deviance"}, \code{"class"}, \code{"mse"} or \code{"mae"}
(see \code{\link[glmnet]{cv.glmnet}})}

\item{alpha.base}{elastic net mixing parameter for base learners\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{alpha.meta}{elastic net mixing parameter for meta learner\strong{:}
numeric between \eqn{0} (ridge) and \eqn{1} (lasso)}

\item{mnorm, spls, sier, mrce}{experimental arguments\strong{:}
logical (requires packages \code{spls}, \code{SiER}, or \code{MRCE})}

\item{...}{further arguments passed to \code{\link[glmnet]{glmnet}}
and \code{\link[glmnet]{cv.glmnet}}}
}
\value{
This function returns a matrix with \eqn{q} columns,
including the cross-validated loss.
}
\description{
Compares univariate and multivariate regression
}
\examples{
n <- 40; q <- 2; p <- 20
Y <- matrix(rnorm(n*q),nrow=n,ncol=q)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
cv.joinet(Y=Y,X=X)

}
