% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_get_bullet.R
\name{jpinfect_get_bullet}
\alias{jpinfect_get_bullet}
\title{Download the bullet reports from the Japan Institute for Health Security (JIHS)}
\usage{
jpinfect_get_bullet(
  year = NULL,
  week = 1:53,
  language = "en",
  overwrite = FALSE,
  dest_dir = NULL
)
}
\arguments{
\item{year}{An integer specifying the year of the data. Must be provided explicitly and must be greater than 2023.}

\item{week}{A numeric vector specifying the weeks to download (default is 1:53).
Week numbers should be between 1 and 53.}

\item{language}{A character string specifying the language of the data ('en' for English, 'jp' for Japanese).
Default is 'en'.}

\item{overwrite}{A logical value indicating whether to overwrite existing files (default is FALSE).
If FALSE, existing files are skipped, and only new files are downloaded.}

\item{dest_dir}{Directory to save files. If NULL, uses tempdir() (files deleted when R session ends).
Specify a permanent directory to keep downloaded data.}
}
\value{
No return value. The function downloads surveillance data files from JIHS and saves them
        to the specified directory (`dest_dir`). If the data is unavailable for certain weeks, those weeks
        are skipped, and an appropriate message is displayed.
}
\description{
This function downloads surveillance data from the Japan Institute for Health Security (JIHS)
for a specified year and weeks, based on the chosen language (English or Japanese).
}
\details{
- The function constructs a URL for JIHS data based on the year, week, and language using `jpinfect_url_bullet`.
- If the specified week is invalid (not between 1 and 53), an error is raised.
- If the year is earlier than 2024, an error is raised, as the function only works for years after 2023.
- Weeks without available data on the server are skipped, and a warning is displayed for each unavailable week.
- If the requested file already exists and `overwrite = FALSE`, it is skipped.
- A delay (`Sys.sleep(3)`) is used between downloads to avoid overwhelming the server.
- Progress updates are displayed in the console using `message()`.
}
\examples{
\donttest{
# Download English data for weeks 1 to 5 in 2025
jpinfect_get_bullet(year = 2025, week = 1:5, language = "en", dest_dir = "raw_data")

# Download Japanese data for all weeks in 2025
jpinfect_get_bullet(year = 2025, language = "jp", dest_dir = "raw_data")

# Overwrite existing files and download English data for weeks 10 to 15 in 2025
jpinfect_get_bullet(year = 2025, week = 10:15, language = "en",
                     overwrite = TRUE, dest_dir = "raw_data")
}

}
