% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenBS.R
\name{GenBSImplied}
\alias{GenBSImplied}
\title{Generalized Black Scholes model implied volatility}
\usage{
GenBSImplied(
  s,
  X,
  r,
  price,
  t,
  div_yield,
  PutOpt = FALSE,
  toler = 1e-06,
  max.iter = 100,
  convergence = 1e-08
)
}
\arguments{
\item{s}{the spot price of the asset (the stock price for options on stocks)}

\item{X}{the exercise or strike price of the option}

\item{r}{the continuously compounded rate of interest in decimal (0.10 or 10e-2 for 10\%)
(use \code{\link{equiv.rate}} to convert to a continuously compounded rate)}

\item{price}{the price of the option}

\item{t}{the maturity of the option in years}

\item{div_yield}{the continuously compounded dividend yield (0.05 or 5e-2 for 5\%)
(use \code{\link{equiv.rate}} to convert to a continuously compounded rate)}

\item{PutOpt}{\code{TRUE} for put options, \code{FALSE} for call options}

\item{toler}{passed on to \code{\link{newton.raphson.root}}
The implied volatility is regarded as correct if the solver is able to
match the option price to within less than \code{toler}. Otherwise the function returns \code{NA}}

\item{max.iter}{passed on to \code{\link{newton.raphson.root}}}

\item{convergence}{passed on to \code{\link{newton.raphson.root}}}
}
\description{
Find implied volatility given the option price using the generalized Black Scholes model.
"Generalized" means that the asset can have a continuous dividend yield.
}
\details{
\code{GenBSImplied} calls \code{\link{newton.raphson.root}} and
if that fails \code{\link{uniroot}}
}
