% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svyjskm.R
\name{svyjskm}
\alias{svyjskm}
\title{Creates a Weighted Kaplan-Meier plot - svykm.object in survey package}
\usage{
svyjskm(
  sfit,
  xlabs = "Time-to-event",
  ylabs = "Survival probability",
  xlims = NULL,
  ylims = c(0, 1),
  ystratalabs = NULL,
  ystrataname = NULL,
  surv.scale = c("default", "percent"),
  timeby = NULL,
  main = "",
  pval = FALSE,
  pval.size = 5,
  pval.coord = c(NULL, NULL),
  pval.testname = F,
  legend = TRUE,
  legendposition = c(0.85, 0.8),
  ci = NULL,
  linecols = "Set1",
  dashed = FALSE,
  cumhaz = F,
  design = NULL,
  subs = NULL,
  table = F,
  label.nrisk = "Numbers at risk",
  size.label.nrisk = 10,
  cut.landmark = NULL,
  ...
)
}
\arguments{
\item{sfit}{a svykm object}

\item{xlabs}{x-axis label, Default: 'Time-to-event'}

\item{ylabs}{y-axis label.}

\item{xlims}{numeric: list of min and max for x-axis. Default: NULL}

\item{ylims}{numeric: list of min and max for y-axis. Default: c(0, 1)}

\item{ystratalabs}{character list. A list of names for each strata. Default: NULL}

\item{ystrataname}{The legend name. Default: 'Strata'}

\item{surv.scale}{scale transformation of survival curves. Allowed values are "default" or "percent".}

\item{timeby}{numeric: control the granularity along the time-axis; defaults to 7 time-points.}

\item{main}{plot title, Default: ''}

\item{pval}{logical: add the pvalue to the plot?, Default: FALSE}

\item{pval.size}{numeric value specifying the p-value text size. Default is 5.}

\item{pval.coord}{numeric vector, of length 2, specifying the x and y coordinates of the p-value. Default values are NULL}

\item{pval.testname}{logical: add '(Log-rank)' text to p-value. Default = F}

\item{legend}{logical. should a legend be added to the plot? Default: TRUE}

\item{legendposition}{numeric. x, y position of the legend if plotted. Default: c(0.85, 0.8)}

\item{ci}{logical. Should confidence intervals be plotted. Default = NULL}

\item{linecols}{Character. Colour brewer pallettes too colour lines. Default: 'Set1', "black" for black with dashed line.}

\item{dashed}{logical. Should a variety of linetypes be used to identify lines. Default: FALSE}

\item{cumhaz}{Show cumulaive hazard function, Default: F}

\item{design}{Data design for reactive design data , Default: NULL}

\item{subs}{= NULL,}

\item{table}{logical: Create a table graphic below the K-M plot, indicating at-risk numbers?}

\item{label.nrisk}{Numbers at risk label. Default = "Numbers at risk"}

\item{size.label.nrisk}{Font size of label.nrisk. Default = 10}

\item{cut.landmark}{cut-off for landmark analysis, Default = NULL}

\item{...}{PARAM_DESCRIPTION}
}
\value{
plot
}
\description{
Creates a Weighted Kaplan-Meier plot - svykm.object in survey package
}
\details{
DETAILS
}
\examples{
 library(survey)
 data(pbc, package="survival")
 pbc$randomized <- with(pbc, !is.na(trt) & trt>0)
 biasmodel <- glm(randomized~age*edema,data=pbc)
 pbc$randprob <- fitted(biasmodel)
 dpbc <- svydesign(id=~1, prob=~randprob, strata=~edema, data=subset(pbc,randomized))
 s1 <- svykm(Surv(time,status>0)~sex, design=dpbc)
 svyjskm(s1)
}
