% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestcox.R
\name{forestcoxServer}
\alias{forestcoxServer}
\title{forestcoxServer:shiny module server for forestcox}
\usage{
forestcoxServer(
  id,
  data,
  data_label,
  data_varStruct = NULL,
  nfactor.limit = 10,
  design.survey = NULL
)
}
\arguments{
\item{id}{id}

\item{data}{Reactive data}

\item{data_label}{Reactive data label}

\item{data_varStruct}{Reactive List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}

\item{design.survey}{reactive survey data. default: NULL}
}
\value{
Shiny module server for forestcox
}
\description{
Shiny module server for forestcox
}
\details{
Shiny module server for forestcox
}
\examples{

library(shiny);library(DT);

mtcars$vs<-factor(mtcars$vs)
mtcars$am<-factor(mtcars$am)
mtcars$kk<-factor(as.integer(mtcars$disp>= 150))
mtcars$kk1<-factor(as.integer(mtcars$disp >= 200))

out<-mtcars
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      forestcoxUI('Forest')
    ),
    mainPanel(
      DTOutput('tablesub')
    )
  )
)


server <- function(input, output, session) {
  data<-reactive(out)
 label<-reactive(jstable::mk.lev(out))
 outtable<-forestcoxServer('Forest',data=data,data_label=label)
  output$tablesub<-renderDT({
    outtable()
  })
}


}
\seealso{
\code{\link[data.table]{data.table-package}}, \code{\link[data.table]{setDT}}, \code{\link[data.table]{setattr}}
 \code{\link[jstable]{TableSubgroupMultiCox}}
 \code{\link[forestploter]{forest_theme}}, \code{\link[forestploter]{forest}}
 \code{\link[rvg]{dml}}
 \code{\link[officer]{read_pptx}}, \code{\link[officer]{add_slide}}, \code{\link[officer]{ph_with}}, \code{\link[officer]{ph_location}}
}
