% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint_trait_prob.R
\name{joint_trait_prob}
\alias{joint_trait_prob}
\title{Computes joint probabilities.}
\usage{
joint_trait_prob(
  m,
  indexTrait,
  bounds,
  Xnew = NULL,
  FullPost = FALSE,
  samples = NULL,
  parallel = FALSE
)
}
\arguments{
\item{m}{a model fitted with \code{jtdm_fit}}

\item{indexTrait}{A vector of the names (as specified in the column names of Y) of the two (or more!) traits we want to compute the joint probabilities of.}

\item{bounds}{The parameter to specify a region in the community-trait space where the function computes the joint probabilities of traits. It is a list of the length of "indexTrait", each element of the list is a vector of length two. The vector represents the inferior and superior bounds of the region for the specified trait. For example, if we consider two traits, bounds=list(c(10,Inf),c(10,Inf)) corresponds to the region in the community-trait space where both traits both take values greater than 10.}

\item{Xnew}{Optionally, a data frame in which to look for variables with which to predict. If omitted, the fitted linear predictors are used.}

\item{FullPost}{If FullPost = TRUE, the function returns samples from the predictive distribution of joint  probabilities, thus allowing the computation of credible intervals. If FullPost= FALSE, joint probabilities are computed only using the posterior mean of the parameters. FullPost cannot be equal to "mean" here.}

\item{samples}{Optional, default to NULL, only works when FullPost=FALSE. Defines the number of posterior samples to compute the posterior distribution of joint probabilities. Needs to be between 1 the total number of samples drawn from the posterior distribution.}

\item{parallel}{Optional, only works when \code{FullPost = TRUE}. When \code{parallel = TRUE}, the function uses mclapply to parallelise the calculation of the posterior distribution joint probabilities.}
}
\value{
A list containing:
   \item{PROBsamples}{Samples from the posterior distribution of the joint probability.NULL if FullPost=FALSE. }
   
   \item{PROBmean}{Posterior mean of the joint probability.}
   
   \item{PROBq975,PROBq025}{97.5\% and 0.25\% posterior quantiles of the joint probability. NULL if FullPost=FALSE. }
}
\description{
Computes the joint probability of CWM traits in regions in the community-trait space specified by bounds and in sites specified in Xnew.
}
\details{
This function is time consuming when \code{FullPost = TRUE}. Consider setting \code{parallel = TRUE} and/or to set \code{samples} to a value smaller than the total number of posterior samples .
}
\examples{
data(Y)  
data(X)  
#We sample only few samples from the posterior in order to reduce
# the computational time of the examples.
#Increase the number of samples to obtain robust results
m = jtdm_fit(Y = Y, X = X, formula = as.formula("~GDD+FDD+forest"), sample = 10)  
# Compute probability of SLA and LNC to be joint-high at sites in the studies
joint = joint_trait_prob(m, indexTrait = c("SLA","LNC"),
                         bounds = list(c(mean(Y[,"SLA"]),Inf), c(mean(Y[,"SLA"]),Inf)),
                         FullPost = TRUE)
}
