% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUI_juicr.R
\name{GUI_juicr}
\alias{GUI_juicr}
\title{A GUI screener to quickly code candidate studies for inclusion/exclusion into
a systematic review or meta-analysis.}
\usage{
GUI_juicr(
  theFigureFile = "",
  theJuicrFile = "",
  standardizeTheImage = TRUE,
  standardSize = 1000,
  figureWindowSize = c(800, 600),
  pointSize = 6,
  animateDelay = TRUE,
  groupNames = c("orangeGrp", "berryGrp", "cherryGrp", "plumGrp", "kiwiGrp",
    "bananaGrp", "grapeGrp", "pruneGrp"),
  groupColors = c("dark orange", "turquoise3", "tomato3", "orchid", "yellow green",
    "goldenrod2", "plum4", "saddle brown")
)
}
\arguments{
\item{theFigureFile}{An optional file name and location of a .jpg, .png, or
.tiff file containing the scientific image/plot/chart/figure to pre-load
in the GUI. Within the GUI there is also a button to select the image file.
Images in other formats should be converted to .png prior to using juicr.}

\item{theJuicrFile}{An optional file name and location of a *_juicr.html
report containing extractions and images from a previous juicr
session to pre-load into the GUI. Within the GUI there is also a button to
select an .html file.}

\item{standardizeTheImage}{When \code{"TRUE"}, all large images are
standardized to a common size with a width specified
by \code{"standardSize"}. When \code{"FALSE"}, the image is unaltered
in size.}

\item{standardSize}{The common width in pixels for standardizing large images;
default is a width of 1000 pixels.}

\item{figureWindowSize}{Specifies the window size containing the image. By
default, this image-viewer window will be 800 (width) by 600 (height)
pixels, larger images will be scrollable to fit this window.}

\item{pointSize}{Changes the default size of a clickable data-point on the
image. Size is the radius in pixels (default is 6).}

\item{animateDelay}{When \code{"TRUE"}, creates a very small pause when
plotting individual automated extractions -- giving an animated effect.}

\item{groupNames}{A vector of the default eight names specifying the
labels of each group. Default labels are fruit themed. Can be any size,
but GUI will only print first 9 characters.}

\item{groupColors}{A vector of the default eight color names specifying the
coloring of each group. Are in color-names format, but can also be HEX.}
}
\value{
A console message of where saved .csv or *_juicr.html files are located.
}
\description{
A GUI screener to help scan and evaluate the title and abstract of studies to
be included in a systematic review or meta-analysis. A description of GUI
options and layout is found here: \url{http://lajeunesse.myweb.usf.edu/juicr/juicr_basic_vignette_v0.1.html}.
}
\note{
\strong{Installation and troubleshooting}\cr\cr For Mac OS users,
   installation is sometimes not straighforward as this GUI requires the
   Tcl/Tk GUI toolkit to be installed. You can get this toolkit by making sure
   the latest X11 application (xQuartz) is installed, see here:
   \url{https://www.xquartz.org/}. More information on
   installation is found in \code{juicrs}'s vignette.
}
\examples{
\dontrun{

GUI_juicr(system.file("images", "Kortum_and_Acymyan_2013_Fig4.jpg", package = "juicr"))

}

}
