% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jjcsformats.R
\name{jjcsformat_count_denom_fraction}
\alias{jjcsformat_count_denom_fraction}
\title{Formatting count, denominator and fraction values}
\usage{
jjcsformat_count_denom_fraction(x, d = 1, roundmethod = c("sas", "iec"), ...)
}
\arguments{
\item{x}{\code{numeric}\cr with elements \code{num} and \code{fraction} or \code{num}, \code{denom} and \code{fraction}.}

\item{d}{numeric(1). Number of digits to round fraction to (default=1)}

\item{roundmethod}{(\code{string})\cr choice of rounding methods. Options are:
\itemize{
\item \code{sas}: the underlying rounding method is \code{tidytlg::roundSAS}, where \cr
roundSAS comes from this Stack Overflow post https://stackoverflow.com/questions/12688717/round-up-from-5
\item \code{iec}: the underlying rounding method is \code{round}
}}

\item{...}{Additional arguments passed to other methods.}
}
\value{
\code{x}, formatted into a string with the appropriate
format and \code{d} digits of precision.
}
\description{
Formatting count, denominator and fraction values
}
\examples{
jjcsformat_count_denom_fraction(c(7, 10, 0.7))
jjcsformat_count_denom_fraction(c(70000, 70001, 70000 / 70001))
jjcsformat_count_denom_fraction(c(235, 235, 235 / 235))
}
