% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/event_date.R
\docType{methods}
\name{event}
\alias{event}
\alias{event-method}
\alias{predict_event}
\alias{predict_event-method}
\alias{predict_accumulation}
\alias{predict_accumulation-method}
\alias{event,data.frame,numeric-method}
\alias{event,matrix,numeric-method}
\alias{predict_event,EventDate,missing-method}
\alias{predict_event,EventDate,matrix-method}
\alias{predict_accumulation,EventDate,missing-method}
\alias{predict_accumulation,EventDate,matrix-method}
\alias{summary,EventDate-method}
\alias{summary,EventDate,missing-method}
\title{Event and Accumulation Dates}
\usage{
event(object, dates, ...)

predict_event(object, data, ...)

predict_accumulation(object, data, ...)

\S4method{event}{data.frame,numeric}(object, dates, rank = 10, cutoff = NULL, ...)

\S4method{event}{matrix,numeric}(object, dates, rank = 10, cutoff = NULL, ...)

\S4method{predict_event}{EventDate,missing}(object, margin = 1, level = 0.95)

\S4method{predict_event}{EventDate,matrix}(object, data, margin = 1, level = 0.95)

\S4method{predict_accumulation}{EventDate,missing}(object)

\S4method{predict_accumulation}{EventDate,matrix}(object, data)

\S4method{summary}{EventDate}(object, ...)
}
\arguments{
\item{object}{An \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or a
\code{\link{data.frame}} of count data (absolute frequencies).}

\item{dates}{A \code{\link{numeric}} vector of dates expressed in CE years (BCE years
must be given as negative numbers). If named, the names must match
the row names of \code{object}.}

\item{...}{Further arguments to be passed to internal methods.}

\item{data}{A \code{numeric} \code{\link{matrix}} or a \code{\link{data.frame}} of count data
(absolute frequencies)for which to predict event and accumulation dates.}

\item{rank}{An \code{\link{integer}} specifying the number of CA factorial components
to be use for linear model fitting (see details).}

\item{cutoff}{An \code{\link{integer}} giving the cumulative percentage of variance
used to select CA factorial components for linear model fitting (see
details). All compounds with a cumulative percentage of variance of less
than the \code{cutoff} value will be retained.
This argument is defunct: use \code{rank} instead.}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the prediction
will be applied over: \code{1} indicates rows, \code{2} indicates columns.}

\item{level}{A length-one \code{\link{numeric}} vector giving the confidence level.}
}
\value{
\itemize{
\item \code{event()} returns an \linkS4class{EventDate} object.
\item \code{predict_event()} returns a \code{\link{data.frame}}.
\item \code{predict_accumulation()} returns a \linkS4class{MeanDate} object.
}
}
\description{
\itemize{
\item \code{event()} fit a date event model.
\item \code{predict_event()} and \code{predict_accumulation()} estimates the event and
accumulation dates of an assemblage.
}
}
\details{
This is an implementation of the chronological modeling method proposed by
Bellanger and Husi (2012, 2013).

Event and accumulation dates are density estimates of the occupation and
duration of an archaeological site (Bellanger and Husi 2012, 2013).
The event date is an estimation of the \emph{terminus post-quem} of an
archaeological assemblage. The accumulation date represents the
"chronological profile" of the assemblage. According to Bellanger and Husi
(2012), accumulation date can be interpreted "at best [...] as a formation
process reflecting the duration or succession of events on the scale of
archaeological time, and at worst, as imprecise dating due to contamination
of the context by residual or intrusive material." In other words,
accumulation dates estimate occurrence of archaeological events and rhythms
of the long term.

This method relies on strong archaeological and statistical assumptions
(see \code{vignette("event")}).
}
\note{
All results are rounded to zero decimal places (sub-annual precision does
not make sense in most situations). You can change this behavior with
\code{options(kairos.precision = x)} (for \code{x} decimal places).

Bellanger \emph{et al.} did not publish the data supporting their demonstration:
no replication of their results is possible. This implementation must be
considered \strong{experimental} and subject to major changes in a future
release.
}
\examples{
\dontrun{
utils::vignette("event")
}
}
\references{
Bellanger, L. & Husi, P. (2013). Mesurer et modéliser le temps inscrit dans
la matière à partir d'une source matérielle : la céramique médiévale.
In \emph{Mesure et Histoire Médiévale}. Histoire ancienne et médiévale.
Paris: Publication de la Sorbonne, p. 119-134.

Bellanger, L. & Husi, P. (2012). Statistical Tool for Dating and
Interpreting Archaeological Contexts Using Pottery. \emph{Journal of
Archaeological Science}, 39(4), 777-790. \doi{10.1016/j.jas.2011.06.031}.

Bellanger, L., Tomassone, R. & Husi, P. (2008). A Statistical Approach for
Dating Archaeological Contexts. \emph{Journal of Data Science}, 6, 135-154.

Bellanger, L., Husi, P. & Tomassone, R. (2006). Une approche statistique
pour la datation de contextes archéologiques. \emph{Revue de Statistique
Appliquée}, 54(2), 65-81.

Bellanger, L., Husi, P. & Tomassone, R. (2006). Statistical Aspects of
Pottery Quantification for the Dating of Some Archaeological Contexts.
\emph{Archaeometry}, 48(1), 169-183. \doi{10.1111/j.1475-4754.2006.00249.x}.

Poblome, J. & Groenen, P. J. F. (2003). Constrained Correspondence Analysis
for Seriation of Sagalassos Tablewares. In Doerr, M. & Apostolis, S. (eds.),
\emph{The Digital Heritage of Archaeology}. Athens: Hellenic Ministry of Culture.
}
\seealso{
\link[=plot_event]{plot()}, \link[=resample_event]{jackknife()},
\link[=resample_event]{bootstrap()}

Other dating methods: 
\code{\link{mcd}()}
}
\author{
N. Frerebeau
}
\concept{dating methods}
