% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/seriate_permute.R
\docType{methods}
\name{permute}
\alias{permute}
\alias{permute-method}
\alias{get_order}
\alias{get_order-method}
\alias{permute,data.frame,PermutationOrder-method}
\alias{permute,matrix,PermutationOrder-method}
\alias{get_order,PermutationOrder-method}
\title{Rearranges a Data Matrix}
\usage{
permute(object, order, ...)

get_order(x, ...)

\S4method{permute}{data.frame,PermutationOrder}(object, order)

\S4method{permute}{matrix,PermutationOrder}(object, order)

\S4method{get_order}{PermutationOrder}(x, margin = c(1, 2))
}
\arguments{
\item{object}{An \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or a
\code{\link{data.frame}} of count data (absolute frequencies).}

\item{...}{Currently not used.}

\item{x, order}{A \linkS4class{PermutationOrder} object giving the permutation
order for rows and columns.}

\item{margin}{A \code{\link{numeric}} vector giving the subscripts which the
rearrangement will be applied over: \code{1} indicates rows, \code{2} indicates
columns, \code{c(1, 2)} indicates rows and columns.}
}
\value{
A permuted \code{matrix} or a permuted \code{data.frame} (the same as \code{object}).
}
\description{
\itemize{
\item \code{permute()} rearranges a data matrix according to a permutation order.
\item \code{get_order()} returns the seriation order for rows and columns.
}
}
\examples{
## Replicates Desachy 2004 results
## Coerce dataset to abundance matrix
data("compiegne", package = "folio")

## Get seriation order for columns on EPPM using the reciprocal averaging method
## Expected column order: N, A, C, K, P, L, B, E, I, M, D, G, O, J, F, H
(indices <- seriate_rank(compiegne, EPPM = TRUE, margin = 2))

## Get permutation order
get_order(indices, 1) # rows
get_order(indices, 2) # columns

## Permute columns
(new <- permute(compiegne, indices))

## See the vignette
\dontrun{
utils::vignette("seriation")
}
}
\seealso{
\code{\link[dimensio:ca]{dimensio::ca()}}

Other seriation methods: 
\code{\link{seriate_average}()},
\code{\link{seriate_rank}()},
\code{\link{seriate_refine}()}
}
\author{
N. Frerebeau
}
\concept{seriation methods}
