% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-dropout.R
\name{layer_dropout}
\alias{layer_dropout}
\title{Applies Dropout to the input.}
\usage{
layer_dropout(object, rate, noise_shape = NULL, seed = NULL,
  batch_size = NULL, name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{rate}{float between 0 and 1. Fraction of the input units to drop.}

\item{noise_shape}{1D integer tensor representing the shape of the binary
dropout mask that will be multiplied with the input. For instance, if your
inputs have shape \code{(batch_size, timesteps, features)} and you want the
dropout mask to be the same for all timesteps, you can use
\code{noise_shape=c(batch_size, 1, features)}.}

\item{seed}{integer to use as random seed.}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Dropout consists in randomly setting a fraction \code{rate} of input units to 0 at
each update during training time, which helps prevent overfitting.
}
\seealso{
Other core layers: \code{\link{layer_activation}},
  \code{\link{layer_activity_regularization}},
  \code{\link{layer_dense}}, \code{\link{layer_flatten}},
  \code{\link{layer_input}}, \code{\link{layer_lambda}},
  \code{\link{layer_masking}}, \code{\link{layer_permute}},
  \code{\link{layer_repeat_vector}},
  \code{\link{layer_reshape}}

Other dropout layers: \code{\link{layer_spatial_dropout_1d}},
  \code{\link{layer_spatial_dropout_2d}},
  \code{\link{layer_spatial_dropout_3d}}
}
