% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_random_brightness}
\alias{layer_random_brightness}
\title{A preprocessing layer which randomly adjusts brightness during training}
\usage{
layer_random_brightness(
  object,
  factor,
  value_range = c(0, 255),
  seed = NULL,
  ...
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{factor}{Float or a list of 2 floats between -1.0 and 1.0. The
factor is used to determine the lower bound and upper bound of the
brightness adjustment. A float value will be chosen randomly between
the limits. When -1.0 is chosen, the output image will be black, and
when 1.0 is chosen, the image will be fully white. When only one float
is provided, eg, 0.2, then -0.2 will be used for lower bound and 0.2
will be used for upper bound.}

\item{value_range}{Optional list of 2 floats for the lower and upper limit
of the values of the input data. Defaults to \verb{[0.0, 255.0]}. Can be changed
to e.g. \verb{[0.0, 1.0]} if the image input has been scaled before this layer.
The brightness adjustment will be scaled to this range, and the
output values will be clipped to this range.}

\item{seed}{optional integer, for fixed RNG behavior.}

\item{...}{standard layer arguments.}
}
\description{
A preprocessing layer which randomly adjusts brightness during training
}
\details{
This layer will randomly increase/reduce the brightness for the input RGB
images. At inference time, the output will be identical to the input.
Call the layer with \code{training=TRUE} to adjust the brightness of the input.

Note that different brightness adjustment factors
will be apply to each the images in the batch.

For an overview and full list of preprocessing layers, see the preprocessing
\href{https://www.tensorflow.org/guide/keras/preprocessing_layers}{guide}.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/RandomBrightness}
\item \url{https://keras.io/api/layers}
}

Other image augmentation layers: 
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()}

Other preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_center_crop}()},
\code{\link{layer_discretization}()},
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_resizing}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{image augmentation layers}
\concept{preprocessing layers}
