% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predict_proba}
\alias{predict_proba}
\alias{predict_classes}
\title{Generates probability or class probability predictions for the input samples.}
\usage{
predict_proba(object, x, batch_size = NULL, verbose = 0, steps = NULL)

predict_classes(object, x, batch_size = NULL, verbose = 0, steps = NULL)
}
\arguments{
\item{object}{Keras model object}

\item{x}{Input data (vector, matrix, or array)}

\item{batch_size}{Integer. If unspecified, it will default to 32.}

\item{verbose}{Verbosity mode, 0 or 1.}

\item{steps}{Total number of steps (batches of samples) before declaring the
evaluation round finished. The default \code{NULL} is equal to the number of
samples in your dataset divided by the batch size.}
}
\description{
Generates probability or class probability predictions for the input samples.
}
\details{
The input samples are processed batch by batch.
}
\seealso{
Other model functions: 
\code{\link{compile.keras.engine.training.Model}()},
\code{\link{evaluate.keras.engine.training.Model}()},
\code{\link{evaluate_generator}()},
\code{\link{fit.keras.engine.training.Model}()},
\code{\link{fit_generator}()},
\code{\link{get_config}()},
\code{\link{get_layer}()},
\code{\link{keras_model_sequential}()},
\code{\link{keras_model}()},
\code{\link{multi_gpu_model}()},
\code{\link{pop_layer}()},
\code{\link{predict.keras.engine.training.Model}()},
\code{\link{predict_generator}()},
\code{\link{predict_on_batch}()},
\code{\link{summary.keras.engine.training.Model}()},
\code{\link{train_on_batch}()}
}
\concept{model functions}
