% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_auc}
\alias{metric_auc}
\title{Approximates the AUC (Area under the curve) of the ROC or PR curves.}
\usage{
metric_auc(
  ...,
  num_thresholds = 200L,
  curve = "ROC",
  summation_method = "interpolation",
  name = NULL,
  dtype = NULL,
  thresholds = NULL,
  multi_label = FALSE,
  num_labels = NULL,
  label_weights = NULL,
  from_logits = FALSE
)
}
\arguments{
\item{...}{For forward/backward compatability.}

\item{num_thresholds}{(Optional) The number of thresholds to
use when discretizing the roc curve. Values must be > 1.
Defaults to \code{200}.}

\item{curve}{(Optional) Specifies the name of the curve to be computed,
\code{'ROC'} (default) or \code{'PR'} for the Precision-Recall-curve.}

\item{summation_method}{(Optional) Specifies the \href{https://en.wikipedia.org/wiki/Riemann_sum}{Riemann summation method} used.
'interpolation' (default) applies mid-point summation scheme for
\code{ROC}.  For PR-AUC, interpolates (true/false) positives but not
the ratio that is precision (see Davis & Goadrich 2006 for
details); 'minoring' applies left summation for increasing
intervals and right summation for decreasing intervals; 'majoring'
does the opposite.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}

\item{thresholds}{(Optional) A list of floating point values to use as the
thresholds for discretizing the curve. If set, the \code{num_thresholds}
parameter is ignored. Values should be in \verb{[0, 1]}. Endpoint
thresholds equal to \{\code{-epsilon}, \code{1+epsilon}\} for a small positive
epsilon value will be automatically included with these to correctly
handle predictions equal to exactly 0 or 1.}

\item{multi_label}{boolean indicating whether multilabel data should be
treated as such, wherein AUC is computed separately for each label
and then averaged across labels, or (when \code{FALSE}) if the data
should be flattened into a single label before AUC computation. In
the latter case, when multilabel data is passed to AUC, each
label-prediction pair is treated as an individual data point. Should
be set to `FALSE`` for multi-class data.}

\item{num_labels}{(Optional) The number of labels, used when \code{multi_label} is
TRUE. If \code{num_labels} is not specified, then state variables get
created on the first call to \code{update_state}.}

\item{label_weights}{(Optional) list, array, or tensor of non-negative weights
used to compute AUCs for multilabel data. When \code{multi_label} is
TRUE, the weights are applied to the individual label AUCs when they
are averaged to produce the multi-label AUC. When it's FALSE, they
are used to weight the individual label predictions in computing the
confusion matrix on the flattened data. Note that this is unlike
\code{class_weights} in that \code{class_weights} weights the example
depending on the value of its label, whereas \code{label_weights} depends
only on the index of that label before flattening; therefore
\code{label_weights} should not be used for multi-class data.}

\item{from_logits}{boolean indicating whether the predictions (\code{y_pred} in
\code{update_state}) are probabilities or sigmoid logits. As a rule of thumb,
when using a keras loss, the \code{from_logits} constructor argument of the
loss should match the AUC \code{from_logits} constructor argument.}
}
\value{
a \code{Metric} instance is returned. The \code{Metric} instance can be passed
directly to \code{compile(metrics = )}, or used as a standalone object. See
\code{?Metric} for example usage.
}
\description{
The AUC (Area under the curve) of the ROC (Receiver operating
characteristic; default) or PR (Precision Recall) curves are quality
measures of binary classifiers. Unlike the accuracy, and like cross-entropy
losses, ROC-AUC and PR-AUC evaluate all the operational points of a model.

This class approximates AUCs using a Riemann sum. During the metric
accumulation phrase, predictions are accumulated within predefined buckets
by value. The AUC is then computed by interpolating per-bucket averages.
These buckets define the evaluated operational points.

This metric creates four local variables, \code{true_positives},
\code{true_negatives}, \code{false_positives} and \code{false_negatives} that are used to
compute the AUC.  To discretize the AUC curve, a linearly spaced set of
thresholds is used to compute pairs of recall and precision values. The area
under the ROC-curve is therefore computed using the height of the recall
values by the false positive rate, while the area under the PR-curve is the
computed using the height of the precision values by the recall.

This value is ultimately returned as \code{auc}, an idempotent operation that
computes the area under a discretized curve of precision versus recall
values (computed using the aforementioned variables). The \code{num_thresholds}
variable controls the degree of discretization with larger numbers of
thresholds more closely approximating the true AUC. The quality of the
approximation may vary dramatically depending on \code{num_thresholds}. The
\code{thresholds} parameter can be used to manually specify thresholds which
split the predictions more evenly.

For a best approximation of the real AUC, \code{predictions} should be
distributed approximately uniformly in the range \verb{[0, 1]} (if
\code{from_logits=FALSE}). The quality of the AUC approximation may be poor if
this is not the case. Setting \code{summation_method} to 'minoring' or 'majoring'
can help quantify the error in the approximation by providing lower or upper
bound estimate of the AUC.

If \code{sample_weight} is \code{NULL}, weights default to 1.
Use \code{sample_weight} of 0 to mask values.
}
\section{Usage}{
Standalone usage:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m <- metric_auc(num_thresholds = 3)
m$update_state(c(0,   0,   1,   1),
               c(0, 0.5, 0.3, 0.9))
# threshold values are [0 - 1e-7, 0.5, 1 + 1e-7]
# tp = [2, 1, 0], fp = [2, 0, 0], fn = [0, 1, 2], tn = [0, 2, 2]
# tp_rate = recall = [1, 0.5, 0], fp_rate = [1, 0, 0]
# auc = ((((1 + 0.5) / 2) * (1 - 0)) + (((0.5 + 0) / 2) * (0 - 0)))
#     = 0.75
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(0.75, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{m$reset_state()
m$update_state(c(0,   0,   1,   1),
               c(0, 0.5, 0.3, 0.9),
               sample_weight=c(1, 0, 0, 1))
m$result()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor(1.0, shape=(), dtype=float32)

}\if{html}{\out{</div>}}

Usage with \code{compile()} API:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Reports the AUC of a model outputting a probability.
model |> compile(
  optimizer = 'sgd',
  loss = loss_binary_crossentropy(),
  metrics = list(metric_auc())
)

# Reports the AUC of a model outputting a logit.
model |> compile(
  optimizer = 'sgd',
  loss = loss_binary_crossentropy(from_logits = TRUE),
  metrics = list(metric_auc(from_logits = TRUE))
)
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/metrics/classification_metrics#auc-class}
}

Other confusion metrics: \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr

Other metrics: \cr
\code{\link{Metric}()} \cr
\code{\link{custom_metric}()} \cr
\code{\link{metric_binary_accuracy}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_binary_iou}()} \cr
\code{\link{metric_categorical_accuracy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_cosine_similarity}()} \cr
\code{\link{metric_f1_score}()} \cr
\code{\link{metric_false_negatives}()} \cr
\code{\link{metric_false_positives}()} \cr
\code{\link{metric_fbeta_score}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_iou}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_log_cosh_error}()} \cr
\code{\link{metric_mean}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_iou}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_mean_wrapper}()} \cr
\code{\link{metric_one_hot_iou}()} \cr
\code{\link{metric_one_hot_mean_iou}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_precision}()} \cr
\code{\link{metric_precision_at_recall}()} \cr
\code{\link{metric_r2_score}()} \cr
\code{\link{metric_recall}()} \cr
\code{\link{metric_recall_at_precision}()} \cr
\code{\link{metric_root_mean_squared_error}()} \cr
\code{\link{metric_sensitivity_at_specificity}()} \cr
\code{\link{metric_sparse_categorical_accuracy}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_sparse_top_k_categorical_accuracy}()} \cr
\code{\link{metric_specificity_at_sensitivity}()} \cr
\code{\link{metric_squared_hinge}()} \cr
\code{\link{metric_sum}()} \cr
\code{\link{metric_top_k_categorical_accuracy}()} \cr
\code{\link{metric_true_negatives}()} \cr
\code{\link{metric_true_positives}()} \cr
}
\concept{confusion metrics}
\concept{metrics}
