% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-creation.R
\name{keras_model_sequential}
\alias{keras_model_sequential}
\title{Keras Model composed of a linear stack of layers}
\usage{
keras_model_sequential(
  input_shape = NULL,
  name = NULL,
  ...,
  input_dtype = NULL,
  input_batch_size = NULL,
  input_sparse = NULL,
  input_batch_shape = NULL,
  input_name = NULL,
  input_tensor = NULL,
  input_optional = FALSE,
  trainable = TRUE,
  layers = list()
)
}
\arguments{
\item{input_shape}{A shape integer vector,
not including the batch size.
For instance, \code{shape=c(32)} indicates that the expected input
will be batches of 32-dimensional vectors. Elements of this shape
can be \code{NA}; \code{NA} elements represent dimensions where the shape
is not known and may vary (e.g. sequence length).}

\item{name}{Name of model}

\item{...}{additional arguments passed on to \code{keras.layers.InputLayer}.}

\item{input_dtype}{The data type expected by the input, as a string
(e.g. \code{"float32"}, \code{"int32"}...)}

\item{input_batch_size}{Optional static batch size (integer).}

\item{input_sparse}{A boolean specifying whether the expected input will be sparse
tensors. Note that, if \code{sparse} is \code{FALSE}, sparse tensors can still
be passed into the input - they will be densified with a default
value of \code{0}. This feature is only supported with the TensorFlow
backend. Defaults to \code{FALSE}.}

\item{input_batch_shape}{An optional way to specify \code{batch_size} and \code{input_shape} as one argument.}

\item{input_name}{Optional name string for the input layer.
Should be unique in a model (do not reuse the same name twice).
It will be autogenerated if it isn't provided.}

\item{input_tensor}{Optional existing tensor to wrap into the \code{InputLayer}.
If set, the layer will use this tensor rather
than creating a new placeholder tensor.}

\item{input_optional}{Boolean, whether the input is optional or not.
An optional input can accept \code{NULL} values.}

\item{trainable}{Boolean, whether the model's variables should be trainable.
You can also change the trainable status of a model/layer with
\code{\link[=freeze_weights]{freeze_weights()}} and \code{\link[=unfreeze_weights]{unfreeze_weights()}}.}

\item{layers}{List of layers to add to the model.}
}
\value{
A \code{Sequential} model instance.
}
\description{
Keras Model composed of a linear stack of layers
}
\note{
If \code{input_shape} is omitted, then the model layer
shapes, including the final model output shape, will not be known until
the model is built, either by calling the model with an input tensor/array
like \code{model(input)}, (possibly via \code{fit()}/\code{evaluate()}/\code{predict()}), or by
explicitly calling \code{model$build(input_shape)}.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{model <- keras_model_sequential(input_shape = c(784))
model |>
  layer_dense(units = 32) |>
  layer_activation('relu') |>
  layer_dense(units = 10) |>
  layer_activation('softmax')

model |> compile(
  optimizer = 'rmsprop',
  loss = 'categorical_crossentropy',
  metrics = c('accuracy')
)

model
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## Model: "sequential"
## +---------------------------------+------------------------+---------------+
## | Layer (type)                    | Output Shape           |       Param # |
## +=================================+========================+===============+
## | dense (Dense)                   | (None, 32)             |        25,120 |
## +---------------------------------+------------------------+---------------+
## | activation (Activation)         | (None, 32)             |             0 |
## +---------------------------------+------------------------+---------------+
## | dense_1 (Dense)                 | (None, 10)             |           330 |
## +---------------------------------+------------------------+---------------+
## | activation_1 (Activation)       | (None, 10)             |             0 |
## +---------------------------------+------------------------+---------------+
##  Total params: 25,450 (99.41 KB)
##  Trainable params: 25,450 (99.41 KB)
##  Non-trainable params: 0 (0.00 B)

}\if{html}{\out{</div>}}
}

\seealso{
Other model functions: \cr
\code{\link{get_config}()} \cr
\code{\link{get_layer}()} \cr
\code{\link{keras_model}()} \cr
\code{\link{pop_layer}()} \cr
\code{\link{summary.keras.src.models.model.Model}()} \cr

Other model creation: \cr
\code{\link{keras_input}()} \cr
\code{\link{keras_model}()} \cr
}
\concept{model creation}
\concept{model functions}
