% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_huber}
\alias{loss_huber}
\title{Computes the Huber loss between \code{y_true} & \code{y_pred}.}
\usage{
loss_huber(
  y_true,
  y_pred,
  delta = 1,
  ...,
  reduction = "sum_over_batch_size",
  name = "huber_loss",
  dtype = NULL
)
}
\arguments{
\item{y_true}{tensor of true targets.}

\item{y_pred}{tensor of predicted targets.}

\item{delta}{A float, the point where the Huber loss function changes from a
quadratic to linear. Defaults to \code{1.0}.}

\item{...}{For forward/backward compatability.}

\item{reduction}{Type of reduction to apply to loss. Options are \code{"sum"},
\code{"sum_over_batch_size"} or \code{NULL}. Defaults to
\code{"sum_over_batch_size"}.}

\item{name}{Optional name for the instance.}

\item{dtype}{The dtype of the loss's computations. Defaults to \code{NULL}, which
means using \code{config_floatx()}. \code{config_floatx()} is a
\code{"float32"} unless set to different value
(via \code{config_set_floatx()}). If a \code{keras$DTypePolicy} is
provided, then the \code{compute_dtype} will be utilized.}
}
\value{
Tensor with one scalar loss entry per sample.
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{for (x in error) \{
  if (abs(x) <= delta)\{
    loss <- c(loss, (0.5 * x^2))
  \} else if (abs(x) > delta) \{
    loss <- c(loss, (delta * abs(x) - 0.5 * delta^2))
  \}
\}
loss <- mean(loss)
}\if{html}{\out{</div>}}

See: \href{https://en.wikipedia.org/wiki/Huber_loss}{Huber loss}.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- rbind(c(0, 1), c(0, 0))
y_pred <- rbind(c(0.6, 0.4), c(0.4, 0.6))
loss <- loss_huber(y_true, y_pred)
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/losses/regression_losses#huber-class}
}

Other losses: \cr
\code{\link{Loss}()} \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_ctc}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_kl_divergence}()} \cr
\code{\link{loss_log_cosh}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_mean_squared_logarithmic_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_sparse_categorical_crossentropy}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{loss_tversky}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr
}
\concept{losses}
