\name{mbo1d}
\alias{mbo1d}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Efficient global optimization with iterative point proposals
}
\description{
Implements the efficient global optimization algorithm based on Kriging. New design points are generated by the expected improvement criterion or expected quantile improvement criterion. The optimizer of the performance criterion can be choosen as generalized simulated annealing or conditional one dimensional optimization.
}
\usage{
mbo1d(model, fun, nsteps, lower, upper, parinit, isoInput, 
maxRunsMult=1, repMult=1, tol_input=.Machine$double.eps^0.25, addInfo=TRUE, 
envir=parent.frame(), EIopt="1Dmulti", GenSAmaxCall=100, timeAlloc="constant",
EItype="EI")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
\item{model}{
Fitted Kriging model of the experimental design and evaluation measures. See \code{\link[DiceKriging]{km}}
}
\item{fun}{
Loss function to be minimized.
}
\item{nsteps}{
Number of points the efficient global optimizer should compute.
}
\item{lower}{
Vector of lower bounds of the tuning parameters. First element is the lower bound of the first tuning parameter, second element the lower bound of the next tuning parameter etc.
}
\item{upper}{
Vector of upper bounds of the tuning parameters. First element is the upper bound of the first tuning parameter, second element the upper bound of the next tuning parameter etc.
}
\item{parinit}{
Starting value of the one dimensional optimization algorithm. See \code{\link{optimize1dMulti}}.
}
\item{isoInput}{
Force the covariance structure of the km to have only one range parameter. For details see \code{\link[DiceKriging]{km}}.
}
\item{maxRunsMult}{
Multiplies the base number of iterations of the one dimensional algorithm. Default number of iterations are the number of hyperparameters. Only applied, if the argument \code{EIopt} is set to \code{"1Dmulti"}.
}
\item{repMult}{
Multiplies the base number of random starting values of the one dimensional algorithm. Default number of iterations are the number of hyperparameters. Only applied, if the argument \code{EIopt} is set to \code{"1Dmulti"}.
}
\item{tol_input}{
Accuracy threshold of the one dimensional optimization algorithm. See \code{\link{optimize1dMulti}}.
}
\item{addInfo}{
Should additional information be displayed during optimization? (logical value). Default is FALSE.
}
\item{envir}{
Internal variable to store environments. Default is to look up the one higher level environment. Modification is unnecessary.
}
\item{EIopt}{
Specifies which algorithm is used to optimize the expected improvement criterion. Two alternatives are available "1Dmulti" and "GenSA". The former uses the conditional 1D algorithm and the latter generalized, simulated annealing.
}
\item{GenSAmaxCall}{
Maximum number of function calls per parameter to estimate in generalized, simulated annealing. Higher values result in more accurate estimates, but the optimization process is slowed.
}
\item{timeAlloc}{
Specifies how the new noise variance is influenced by iteration progress. Default is to use "constant"" allocation. The other available option is to specify "zero", which corresponds to the original expected improvement criterion.
}
\item{EItype}{
Defines the type of the improvement criterion. The default \code{EI} corresponds to the expected improvement. As an alternative \code{EQI} the expected quantile improvement is also possible.
}
}
\details{
In each step iteration the performance criterion is minimized regarding the design input parameters. The loss function is evaluated at the proposed design point. The Kriging model is updated with the new point and refitted with nugget effect to ensure convergence. The starting value for the next step iteration is set to the parameter values with lowest function value.
}

\value{
Retains the parameter values with the lowest function value. The function value (\code{funcVal}) and the MBO tuning process history (\code{MBOprogress}) are available as attributes.
}

\references{
Olivier Roustant and David Ginsbourger and Yves Deville, (2012), 
\emph{DiceKriging, DiceOptim: Two R Packages for the Analysis of 
Computer Experiments by Kriging-Based Metamodeling and Optimization},
Journal of Statistical Software, Volume 51, Issue 1

Donald R. Jones and Matthias Schonlau and William J. Welch, (1998), 
\emph{Efficient Global Optimization of Expensive Black-Box Functions},
Journal of Global Optimization 13: pages 455-492

Constantino Tsallis and Daniel A. Stariolo, (1996), Generalized Simulated Annealing, Elsevier Physica A: Statistical Mechanics and its Applications, Volume 233, Issues 1-2, 15, Pages 395-406

Victor Picheny, David Ginsbourger, Yann Richet, (2012),
\emph{Quantile-based optimization of Noisy Computer Experiments with Tunable Precision},
HAL-archives-ouvertes.fr, hal-00578550v3
}

\author{
Thomas Welchowski \email{welchow@imbie.meb.uni-bonn.de}
}

\note{
Function is supplied for model customization and intended for the experienced user. The more user friendly function uses this code as intermediate step.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{optimize1dMulti}}, \code{\link[DiceKriging]{km}}, \code{\link[DiceOptim]{EI}}, \code{\link{mboAll}}
}

%\examples{
%}

% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ models & regression }
%\keyword{ ~kwd2 }% __ONLY ONE__ keyword per line