% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-macos.R
\docType{data}
\name{backend_macos}
\alias{backend_macos}
\title{Create a macOS Keychain backend}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
backend_macos
}
\description{
This backend is the default on macOS. It uses the macOS native Keychain
Service API.
}
\details{
It supports multiple keyrings.

See \link{backend} for the documentation of the individual methods.
}
\examples{
\dontrun{
## This only works on macOS
kb <- backend_macos$new()
kb$create_keyring("foobar")
kb$set_default_keyring("foobar")
kb$set_with_value("service", password = "secret")
kb$get("service")
kb$delete("service")
kb$delete_keyring("foobar")
}
}
\seealso{
Other keyring backends: \code{\link{backend_env}},
  \code{\link{backend_file}},
  \code{\link{backend_secret_service}},
  \code{\link{backend_wincred}}
}
\keyword{datasets}
