% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Aggregate-Functions.R
\name{k_model_fit}
\alias{k_model_fit}
\title{Extract model fit}
\usage{
k_model_fit(models, index = c("chisq", "cfi", "rmsea"), by.fold = TRUE)
}
\arguments{
\item{models}{An object returned from \code{\link[kfa]{kfa}}}

\item{index}{One or more fit indices to summarize in the report. The degrees of freedom are always reported. Default are "chisq", "cfi", and "rmsea".}

\item{by.fold}{Should each element in the returned lists be a fold (default) or a factor model?}
}
\value{
\code{list} of data.frames with average model fit for each factor model
}
\description{
Model fit indices extracted from k-folds
}
\examples{
data(example.kfa)

# customize fit indices to report
k_model_fit(example.kfa, index = c("chisq", "cfi", "rmsea", "srmr"))

# organize results by factor model rather than by fold
k_model_fit(example.kfa, by.fold = FALSE)

}
